/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.graphic.util;

import org.joml.Vector4f;

public class IUIMathUtils {
    public static float smoothStep(float start, float end, float v) {
        v = Math.max(0.0f, Math.min(1.0f, (v - start) / (end - start)));
        return v * v * (3.0f - 2.0f * v);
    }

    public static double smoothStep(double start, double end, double v) {
        v = Math.max(0.0, Math.min(1.0, (v - start) / (end - start)));
        return v * v * (3.0 - 2.0 * v);
    }

    public static float smoothPulse(float time, float duration, float riseFraction, float fallFraction) {
        if (time < 0.0f || duration <= 0.0f) {
            return 0.0f;
        }
        float riseEnd = duration * riseFraction;
        float fallStart = duration * (1.0f - fallFraction);
        if (time < riseEnd) {
            return IUIMathUtils.smoothStep(0.0f, riseEnd, time);
        }
        if (time > fallStart) {
            return 1.0f - IUIMathUtils.smoothStep(fallStart, duration, time);
        }
        return 1.0f;
    }

    public static double smoothPulse(double time, double duration, double riseFraction, double fallFraction) {
        if (time < 0.0 || duration <= 0.0) {
            return 0.0;
        }
        double riseEnd = duration * riseFraction;
        double fallStart = duration * (1.0 - fallFraction);
        if (time < riseEnd) {
            return IUIMathUtils.smoothStep(0.0, riseEnd, time);
        }
        if (time > fallStart) {
            return 1.0 - IUIMathUtils.smoothStep(fallStart, duration, time);
        }
        return 1.0;
    }

    public static double smoothTime(double time) {
        return 2.0 * time - time * time;
    }

    public static float smoothTime(float time) {
        return 2.0f * time - time * time;
    }

    public static double bounceTime(double time) {
        return 4.0 * (time - time * time);
    }

    public static float bounceTime(float time) {
        return 4.0f * (time - time * time);
    }

    public static double linearLerp(double src, double dest, float time) {
        return src * (1.0 - (double)time) + dest * (double)time;
    }

    public static float linearLerp(float src, float dest, float time) {
        return src * (1.0f - time) + dest * time;
    }

    public static double smoothLerp(double src, double dest, double time) {
        time = 2.0 * time - time * time;
        return src * (1.0 - time) + dest * time;
    }

    public static float smoothLerp(float src, float dest, float time) {
        time = 2.0f * time - time * time;
        return src * (1.0f - time) + dest * time;
    }

    public static double sCurveLerp(double src, double dest, double time) {
        double sqr = time * time;
        time = 3.0 * sqr - 2.0 * sqr * time;
        return src * (1.0 - time) + dest * time;
    }

    public static float sCurveLerp(float src, float dest, float time) {
        float sqr = time * time;
        time = 3.0f * sqr - 2.0f * sqr * time;
        return src * (1.0f - time) + dest * time;
    }

    public static double bounceLerp(double src, double dest, double time) {
        time = 2.0 * (time - time * time);
        return src * (1.0 - time) + dest * time;
    }

    public static float bounceLerp(float src, float dest, float time) {
        time = 2.0f * (time - time * time);
        return src * (1.0f - time) + dest * time;
    }

    public static Vector4f int2RGBA(int color) {
        return new Vector4f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
    }

    public static Vector4f int2ARGB(int color) {
        return new Vector4f((float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }
}

