/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.graphic.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import org.hiedacamellia.immersiveui.ImmersiveUI;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveui")
public class IUIShaders {
    @Nullable
    private static ShaderInstance roundRect;
    @Nullable
    private static ShaderInstance borderRoundRect;
    @Nullable
    private static ShaderInstance positionTexShader;
    @Nullable
    private static ShaderInstance blurShader;
    @Nullable
    private static ShaderInstance ringShader;
    @Nullable
    private static ShaderInstance roundShader;
    @Nullable
    private static ShaderInstance borderRect;

    public static ShaderInstance getRoundRectShader() {
        return Objects.requireNonNull(roundRect, "Attempted to call getRoundRectShader before shaders have finished loading.");
    }

    public static ShaderInstance getBorderRoundRectShader() {
        return Objects.requireNonNull(borderRoundRect, "Attempted to call getBorderRoundRectShader before shaders have finished loading.");
    }

    public static ShaderInstance getPositionTexShader() {
        return Objects.requireNonNull(positionTexShader, "Attempted to call getPositionTexShader before shaders have finished loading.");
    }

    public static ShaderInstance getBlurShader() {
        return Objects.requireNonNull(blurShader, "Attempted to call getBlurShader before shaders have finished loading.");
    }

    public static ShaderInstance getRingShader() {
        return Objects.requireNonNull(ringShader, "Attempted to call getRingShader before shaders have finished loading.");
    }

    public static ShaderInstance getRoundShader() {
        return Objects.requireNonNull(roundShader, "Attempted to call getRoundShader before shaders have finished loading.");
    }

    public static ShaderInstance getBorderRectShader() {
        return Objects.requireNonNull(borderRect, "Attempted to call getBorderRectShader before shaders have finished loading.");
    }

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) throws IOException {
        ResourceProvider provider = event.getResourceProvider();
        event.registerShader(new ShaderInstance(provider, ImmersiveUI.rl("round_rect"), DefaultVertexFormat.POSITION_TEX_COLOR), shader -> {
            roundRect = shader;
        });
        event.registerShader(new ShaderInstance(provider, ImmersiveUI.rl("border_round_rect"), DefaultVertexFormat.POSITION_TEX_COLOR), shader -> {
            borderRoundRect = shader;
        });
        event.registerShader(new ShaderInstance(provider, ImmersiveUI.rl("position_tex"), DefaultVertexFormat.POSITION_TEX), shader -> {
            positionTexShader = shader;
        });
        event.registerShader(new ShaderInstance(provider, ImmersiveUI.rl("blur"), DefaultVertexFormat.POSITION_TEX), shader -> {
            blurShader = shader;
        });
        event.registerShader(new ShaderInstance(provider, ImmersiveUI.rl("ring"), DefaultVertexFormat.POSITION_TEX), shader -> {
            ringShader = shader;
        });
        event.registerShader(new ShaderInstance(provider, ImmersiveUI.rl("round"), DefaultVertexFormat.POSITION_TEX), shader -> {
            roundShader = shader;
        });
        event.registerShader(new ShaderInstance(provider, ImmersiveUI.rl("border_rect"), DefaultVertexFormat.POSITION_TEX_COLOR), shader -> {
            borderRect = shader;
        });
    }
}

