/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIMathUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.toast.IToastWidget;

public abstract class AbstractToastWidget
extends AbstractWidget
implements IToastWidget {
    protected float timeout;
    protected float count = 0.0f;
    protected boolean fadeIn = true;

    public AbstractToastWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    protected float getAlpha() {
        float alpha = 1.0f;
        if (this.fadeIn) {
            alpha = this.count < this.timeout * 0.5f ? IUIMathUtils.smoothStep(0.0f, this.timeout * 0.1f, this.count) : 1.0f - IUIMathUtils.smoothStep(this.timeout * 0.9f, this.timeout, this.count);
        }
        return alpha;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.count > this.timeout) {
            return;
        }
        if (this.getMessage().getString().isEmpty()) {
            return;
        }
        this.count += partialTick;
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(0.0, 0.0, 1000.0);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
        this.renderToast(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        pose.popPose();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    @Override
    public void setTimeout(float timeout) {
        this.timeout = timeout;
    }
}

