/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.component;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIMinecraftUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.component.MultiFormattedCharSequenceWidget;

public class ComponentWidget
extends AbstractStringWidget {
    protected static final Font font = IUIMinecraftUtils.getFont();
    protected Component component;
    protected boolean shadow;

    public ComponentWidget(Component component) {
        this(0, 0, component);
    }

    public ComponentWidget(int x, int y, Component component) {
        int n = font.width((FormattedText)component);
        Objects.requireNonNull(font);
        super(x, y, n, 9, component, font);
        this.shadow = true;
        this.component = component;
    }

    public ComponentWidget(int x, int y, int w, int h, Component component) {
        super(x, y, w, h, component, font);
        this.shadow = true;
    }

    public ComponentWidget setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.drawString(font, this.component, this.getX(), this.getY(), this.getColor(), this.shadow);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public MultiFormattedCharSequenceWidget toMultiFormatted(int width) {
        return new MultiFormattedCharSequenceWidget(this.getX(), this.getY(), width, font.split((FormattedText)this.component, width)).setShadow(this.shadow);
    }
}

