/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.tree.wheel;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.TreeEntryWidget;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.TreeWidget;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.wheel.WheelTreeEntryWidget;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.wheel.action.ActionData;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.wheel.action.WheelActionRegistries;

public class WheelTreeWidget
extends TreeWidget<ActionData, WheelTreeEntryWidget> {
    protected int centerX = 0;
    protected int centerY = 0;
    protected float angleOffset = 0.0f;

    public void setAngleOffset(float angleOffset) {
        this.angleOffset = angleOffset;
        this.updateWidget();
    }

    public void resize() {
        this.centerX = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2;
        this.centerY = Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2;
        this.width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        for (WheelTreeEntryWidget child : this.root) {
            child.resize();
        }
    }

    public WheelTreeWidget(List<? extends WheelTreeEntryWidget> root, int x, int y, Component component, Font font) {
        super(root, x, y, component, font);
        this.resize();
    }

    public static WheelTreeWidget create(List<? extends WheelTreeEntryWidget> root, int x, int y, Component component, Font font) {
        return new WheelTreeWidget(root, x, y, component, font);
    }

    @Override
    public void updateWidget() {
        int i = 0;
        int size = this.root.size();
        for (TreeEntryWidget child : this.root) {
            if (child instanceof WheelTreeEntryWidget) {
                WheelTreeEntryWidget widget = (WheelTreeEntryWidget)child;
                widget.setAngle((float)i * 360.0f / (float)size + this.angleOffset, (float)(i + 1) * 360.0f / (float)size + this.angleOffset);
                widget.setRadius(40.0f, 75.0f);
                widget.setLayer(0);
                widget.updateWidget();
            }
            ++i;
        }
    }

    @Override
    protected void renderTitle(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        IUIGuiUtils.drawCenteredString(guiGraphics, this.font, this.getMessage(), (float)this.centerX, (float)this.centerY, -1, false);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean v = super.mouseClicked(mouseX, mouseY, button);
        if (this.select == null) {
            return false;
        }
        if (this.select.getData() != null) {
            WheelActionRegistries.get(((ActionData)this.select.getData()).resourceLocation()).accept(((ActionData)this.select.getData()).compoundTag());
        }
        return v;
    }

    @Override
    public TreeEntryWidget<ActionData> getAt(double mouseX, double mouseY) {
        for (TreeEntryWidget child : this.root) {
            TreeEntryWidget<ActionData> widget = child.getAt(mouseX, mouseY);
            if (widget == null || !widget.isHovered(mouseX, mouseY)) continue;
            return widget;
        }
        return null;
    }
}

