/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.tree;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.hiedacamellia.immersiveui.ImmersiveUI;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.TreeEntryWidget;

public class TreeWidget<T, V extends TreeEntryWidget<T>>
extends AbstractContainerWidget {
    protected Font font;
    protected List<? extends V> root;
    protected TreeEntryWidget<T> onDrag;
    protected TreeEntryWidget<T> select;
    private double dragStartX;
    private double dragStartY;
    private double dragOriginX;
    private double dragOriginY;
    private boolean showTitle = true;
    protected boolean dragable = true;
    protected int titleWidth;
    protected int titleHeight;

    public TreeEntryWidget<T> getSelect() {
        return this.select;
    }

    public boolean isDrag(V widget) {
        return this.onDrag == widget;
    }

    public void hideTitle() {
        this.showTitle = false;
    }

    public void updateWidget() {
        int x = this.getX();
        int y = this.getY();
        int offset = this.showTitle ? this.titleHeight : 0;
        int width = 0;
        for (TreeEntryWidget treeEntryWidget : this.root) {
            treeEntryWidget.setX(x);
            treeEntryWidget.setY(y + offset);
            treeEntryWidget.updateWidget();
            offset += treeEntryWidget.getHeight();
            width = Math.max(width, treeEntryWidget.getWidth());
        }
        this.height = offset;
        this.width = this.showTitle ? Math.max(width, this.titleWidth) : width;
    }

    public TreeWidget(V root, int x, int y, Component component, Font font) {
        super(x, y, 0, 0, component);
        this.font = font;
        this.root = List.of(root);
        ((TreeEntryWidget)((Object)root)).tree(this);
        Objects.requireNonNull(font);
        this.titleHeight = 9;
        this.titleWidth = font.width((FormattedText)component);
        this.updateWidget();
    }

    public TreeWidget(List<? extends V> root, int x, int y, Component component, Font font) {
        super(x, y, 0, 0, component);
        this.font = font;
        this.root = root;
        for (TreeEntryWidget treeEntryWidget : root) {
            treeEntryWidget.tree(this);
        }
        Objects.requireNonNull(font);
        this.titleHeight = 9;
        this.titleWidth = font.width((FormattedText)component);
        this.updateWidget();
    }

    public static <T, V extends TreeEntryWidget<T>> TreeWidget<T, V> of(V root, int x, int y, Component component, Font font) {
        return new TreeWidget<T, V>(root, x, y, component, font);
    }

    public static <T, V extends TreeEntryWidget<T>> TreeWidget<T, V> of(List<V> root, int x, int y, Component component, Font font) {
        return new TreeWidget<T, V>(root, x, y, component, font);
    }

    public TreeEntryWidget<T> getAt(double mouseX, double mouseY) {
        for (TreeEntryWidget child : this.root) {
            TreeEntryWidget widget = child.getAt(mouseX, mouseY);
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    public List<? extends GuiEventListener> children() {
        return this.root;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        TreeEntryWidget<T> child = this.getAt(mouseX, mouseY);
        this.select = child;
        if (child != null && !child.isRoot()) {
            boolean v = child.mouseClicked(mouseX, mouseY, button);
            this.updateWidget();
            if (!v && this.dragable) {
                this.setDragging(true);
                child.fold();
                this.onDrag = child;
                this.dragStartX = mouseX;
                this.dragStartY = mouseY;
                this.dragOriginX = child.getX();
                this.dragOriginY = child.getY();
            }
            return true;
        }
        if (child != null && child.isRoot()) {
            boolean v = child.mouseClicked(mouseX, mouseY, button);
            this.updateWidget();
            return true;
        }
        this.updateWidget();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        if (this.onDrag != null) {
            TreeEntryWidget<T> child = this.getAt(mouseX, mouseY);
            ImmersiveUI.LOGGER.info(child.getMessage().getString());
            if (this.onDrag != child) {
                if (child.shouldAccept(mouseX, mouseY)) {
                    child.accept(this.onDrag);
                } else {
                    child.insert(this.onDrag);
                }
            }
            this.onDrag = null;
            this.updateWidget();
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging()) {
            if (this.onDrag != null) {
                int xOff = (int)(mouseX - this.dragStartX);
                int yOff = (int)(mouseY - this.dragStartY);
                this.onDrag.setX((int)(this.dragOriginX + (double)xOff));
                this.onDrag.setY((int)(this.dragOriginY + (double)yOff));
            }
            return true;
        }
        return false;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        this.renderBg(guiGraphics, mouseX, mouseY, v);
        if (this.showTitle) {
            this.renderTitle(guiGraphics, mouseX, mouseY, v);
        }
        this.renderChildren(guiGraphics, mouseX, mouseY, v);
    }

    protected void renderBg(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -2236963);
    }

    protected void renderTitle(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.titleHeight, -5592406);
        guiGraphics.drawString(this.font, this.getMessage(), this.getX(), this.getY(), 0, false);
    }

    protected void renderChildren(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        for (TreeEntryWidget treeEntryWidget : this.root) {
            treeEntryWidget.render(guiGraphics, mouseX, mouseY, v);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

