/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.event;

import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.hiedacamellia.immersiveui.client.graphic.target.ScreenTempTarget;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.wheel.action.BuiltInWheelActions;
import org.hiedacamellia.immersiveui.client.gui.layer.ScreenWidgetLayer;
import org.hiedacamellia.immersiveui.client.gui.layer.World2ScreenWidgetLayer;

@EventBusSubscriber(modid="immersiveui", value={Dist.CLIENT})
public class IUIClientGameEvent {
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ScreenTempTarget.SCREEN_INSTANCE = new ScreenTempTarget(Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getHeight());
            ScreenTempTarget.BLUR_INSTANCE = new ScreenTempTarget(Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getHeight());
            BuiltInWheelActions.init();
        });
    }

    @SubscribeEvent
    public static void onKey(InputEvent.Key event) {
    }

    @SubscribeEvent
    public static void onMouse(InputEvent.MouseButton.Pre event) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        if (event.getButton() == 0 && event.getAction() == 1) {
            boolean consumed = World2ScreenWidgetLayer.INSTANCE.click(event.getButton());
            event.setCanceled(consumed);
        }
        event.setCanceled(ScreenWidgetLayer.INSTANCE.click(event.getButton(), event.getAction()));
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        event.setCanceled(World2ScreenWidgetLayer.INSTANCE.scroll(event.getMouseX(), event.getMouseY(), event.getScrollDeltaX(), event.getScrollDeltaY()));
    }

    @SubscribeEvent
    public static void onScreen(ScreenEvent.Opening event) {
        if (World2ScreenWidgetLayer.INSTANCE.activeScreen != null) {
            World2ScreenWidgetLayer.INSTANCE.activeScreen.setScreen(event.getNewScreen());
            event.setCanceled(true);
        }
    }
}

