/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.w2s;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.hiedacamellia.immersiveui.client.graphic.target.ScreenTempTarget;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGraphicUtils;
import org.hiedacamellia.immersiveui.client.gui.component.w2s.World2ScreenWidget;
import org.hiedacamellia.immersiveui.client.gui.layer.World2ScreenWidgetLayer;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class World2ScreenScreen
extends World2ScreenWidget {
    protected Minecraft minecraft = Minecraft.getInstance();
    protected Screen screen;
    protected Player player;
    protected int w;
    protected int h;
    protected Vec3 pos;
    protected final RenderTarget mainRenderTarget = Minecraft.getInstance().getMainRenderTarget();

    public void setScreen(Screen screen) {
        this.screen = screen;
        screen.init(this.minecraft, this.w, this.h);
    }

    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public void resize() {
        this.w = this.minecraft.getWindow().getGuiScaledWidth();
        this.h = this.minecraft.getWindow().getGuiScaledHeight();
    }

    public boolean isSameScreen(Screen screen) {
        return this.screen == screen;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.screen.keyPressed(keyCode, scanCode, modifiers);
    }

    public World2ScreenScreen(UUID uuid, Screen screen, Player player) {
        this(uuid, screen, player, World2ScreenScreen.getPlayerEye(player));
    }

    private static Vec3 getPlayerEye(Player player) {
        Vec3 eyePosition = player.getEyePosition();
        Vec3 lookAngle = player.getLookAngle();
        Vec3 normalizedLookAngle = lookAngle.normalize();
        return eyePosition.add(normalizedLookAngle);
    }

    public World2ScreenScreen(UUID uuid, Screen screen, Player player, Vec3 pos) {
        super(uuid);
        this.w = this.minecraft.getWindow().getGuiScaledWidth();
        this.h = this.minecraft.getWindow().getGuiScaledHeight();
        this.screen = screen;
        this.screen.init(this.minecraft, this.w, this.h);
        this.player = player;
        this.pos = pos;
        this.scale = 1.0f;
    }

    @Override
    public boolean click(int button) {
        int mX = (int)(((float)this.w - this.x) / this.scale);
        int mY = (int)(((float)this.h - this.y) / this.scale);
        World2ScreenWidgetLayer.INSTANCE.setActiveScreen(this);
        return this.screen.mouseClicked((double)mX, (double)mY, button);
    }

    @Override
    public boolean scroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        double mX = ((float)this.w - this.x) / this.scale;
        double mY = ((float)this.h - this.y) / this.scale;
        return this.screen.mouseScrolled(mX, mY, scrollX, scrollY);
    }

    @Override
    public void getWorldPos(Vector3f out) {
        out.set((Vector3fc)this.pos.toVector3f());
    }

    @Override
    public void render(GuiGraphics guiGraphics, boolean highlight, float value, DeltaTracker deltaTracker) {
        ScreenTempTarget.SCREEN_INSTANCE.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        ScreenTempTarget.SCREEN_INSTANCE.clear(Minecraft.ON_OSX);
        ScreenTempTarget.BLUR_INSTANCE.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        ScreenTempTarget.BLUR_INSTANCE.clear(Minecraft.ON_OSX);
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        float x1 = this.x - (float)this.w / 2.0f;
        float y1 = this.y - (float)this.h / 2.0f;
        float x2 = this.scale * (float)this.w + x1;
        float y2 = this.scale * (float)this.h + y1;
        int mX = (int)(((float)this.w - this.x) / this.scale);
        int mY = (int)(((float)this.h - this.y) / this.scale);
        this.mainRenderTarget.unbindWrite();
        ScreenTempTarget.BLUR_INSTANCE.bindWrite(true);
        ScreenTempTarget.BLUR_INSTANCE.use = true;
        ScreenTempTarget.SCREEN_INSTANCE.use = true;
        IUIGraphicUtils.blit(pose, this.mainRenderTarget.getColorTextureId(), 0.0f, 0.0f, (float)this.w, (float)this.h, 0.0f, 1.0f, 1.0f, 0.0f);
        this.screen.render(guiGraphics, mX, mY, deltaTracker.getGameTimeDeltaTicks());
        guiGraphics.flush();
        pose.popPose();
        ScreenTempTarget.SCREEN_INSTANCE.unbindWrite();
        ScreenTempTarget.BLUR_INSTANCE.use = false;
        ScreenTempTarget.SCREEN_INSTANCE.use = false;
        this.mainRenderTarget.bindWrite(true);
        pose.pushPose();
        float u0 = x1 / (float)this.w;
        float v0 = y2 / (float)this.h;
        float u1 = x2 / (float)this.w;
        float v1 = y1 / (float)this.h;
        RenderSystem.enableBlend();
        IUIGraphicUtils.blitInUv(pose, ScreenTempTarget.BLUR_INSTANCE.getColorTextureId(), 0.0f, 0.0f, (float)this.w, (float)this.h, u0, 1.0f - v1, u1, 1.0f - v0);
        pose.popPose();
        pose.pushPose();
        pose.translate(this.x - (float)this.w / 2.0f, this.y - (float)this.h / 2.0f, 100.0f);
        pose.scale(this.scale, this.scale, 1.0f);
        IUIGraphicUtils.blit(pose, ScreenTempTarget.SCREEN_INSTANCE.getColorTextureId(), 0.0f, 0.0f, (float)this.w, (float)this.h, 0.0f, 1.0f, 1.0f, 0.0f);
        pose.popPose();
        if (mX >= 0 && mY >= 0 && mX <= this.w && mY <= this.h) {
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 200.0f);
            Minecraft.getInstance().gui.renderCrosshair(guiGraphics, deltaTracker);
            pose.popPose();
            pose.pushPose();
        }
    }

    @Override
    public void calculateRenderScale(float distanceSqr) {
        this.scale = (float)(2.0 * Math.atan2(1.0, Math.sqrt(distanceSqr)));
        if (this.scale > 1.0f) {
            this.scale = 1.0f;
        }
        if (distanceSqr > 64.0f && !this.shouldRemove) {
            World2ScreenWidgetLayer.INSTANCE.remove(this.uuid);
        }
    }
}

