/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.tree.wheel;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.TreeEntryWidget;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.wheel.action.ActionData;

public class WheelTreeEntryWidget
extends TreeEntryWidget<ActionData> {
    protected float startAngle = 0.0f;
    protected float endAngle = 0.0f;
    protected float innerRadius = 0.0f;
    protected float outerRadius = 0.0f;
    protected int centerX = 0;
    protected int centerY = 0;
    protected int layer = 0;

    public void resize() {
        this.centerX = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2;
        this.centerY = Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void setAngle(float startAngle, float endAngle) {
        this.startAngle = startAngle;
        this.endAngle = endAngle;
    }

    public void setRadius(float innerRadius, float outerRadius) {
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
    }

    public WheelTreeEntryWidget(Component message, Font font) {
        super(message, font);
        this.resize();
    }

    public static WheelTreeEntryWidget create(ActionData data, Component component, Font font) {
        WheelTreeEntryWidget widget = new WheelTreeEntryWidget(component, font);
        widget.setData(data);
        return widget;
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        IUIGuiUtils.drawRing(guiGraphics, this.centerX, this.centerY, this.innerRadius, this.outerRadius, this.startAngle, this.endAngle, -2130706433);
        if (this.isHovered(mouseX, mouseY)) {
            IUIGuiUtils.drawRing(guiGraphics, this.centerX, this.centerY, this.innerRadius, this.outerRadius, this.startAngle, this.endAngle, -790766115);
        }
        float midAngle = (this.startAngle + this.endAngle) / 2.0f - 90.0f;
        float midRadius = (this.innerRadius + this.outerRadius) / 2.0f;
        IUIGuiUtils.drawCenteredString(guiGraphics, this.font, this.getMessage(), (float)this.centerX + (float)Math.cos(Math.toRadians(midAngle)) * midRadius, (float)this.centerY + (float)Math.sin(Math.toRadians(midAngle)) * midRadius, -1, false);
        if (this.fold) {
            return;
        }
        this.renderChildren(guiGraphics, mouseX, mouseY, v);
    }

    @Override
    public boolean shouldAccept(double mouseX, double mouseY) {
        return false;
    }

    @Override
    public void updateWidget() {
        int i = 0;
        int size = this.children.size();
        for (TreeEntryWidget child : this.children) {
            if (child instanceof WheelTreeEntryWidget) {
                WheelTreeEntryWidget widget = (WheelTreeEntryWidget)child;
                widget.setAngle((float)i * 360.0f / (float)size, (float)(i + 1) * 360.0f / (float)size);
                widget.setRadius(this.outerRadius + 5.0f, this.outerRadius + 30.0f - (float)(this.layer * 10));
                widget.setLayer(this.layer + 1);
                widget.updateWidget();
            }
            ++i;
        }
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        double x = mouseX - (double)this.centerX;
        double y = mouseY - (double)this.centerY;
        double r = Math.sqrt(x * x + y * y);
        double angle = Math.toDegrees(Math.atan2(y, x)) + 90.0;
        if (angle < 0.0) {
            angle += 360.0;
        } else if (angle > 360.0) {
            angle -= 360.0;
        }
        if (this.startAngle < 0.0f && this.endAngle > 0.0f) {
            boolean left = angle > (double)(this.startAngle + 360.0f) && angle < 360.0;
            boolean reght = angle < (double)this.endAngle && angle > 0.0;
            return r >= (double)this.innerRadius && r <= (double)this.outerRadius && (left || reght);
        }
        if (this.startAngle < 0.0f && this.endAngle < 0.0f) {
            this.startAngle += 360.0f;
            this.endAngle += 360.0f;
        }
        return r >= (double)this.innerRadius && r <= (double)this.outerRadius && angle >= (double)this.startAngle && angle <= (double)this.endAngle;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hasChild()) {
            if (this.isHovered(mouseX, mouseY) && button == 0) {
                if (this.fold) {
                    this.unfold();
                } else {
                    this.fold();
                }
                return true;
            }
            TreeEntryWidget child = this.getWidgetAt(mouseX, mouseY);
            if (child != null) {
                boolean v = child.mouseClicked(mouseX, mouseY, button);
                this.updateWidget();
                return v;
            }
        } else if (button == 0 && this.getData() != null) {
            return false;
        }
        return true;
    }
}

