/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.bar.base;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.bar.AbstractBarWidget;

public class BaseBarWidget
extends AbstractBarWidget {
    protected float borderX = 1.0f;
    protected float borderY = 1.0f;
    protected boolean isVertical = false;
    protected boolean isReverse = false;
    protected float progress = 0.0f;
    protected boolean border = true;
    protected int barColor = -1;
    protected int backColor = -1;
    protected int borderColor = -65536;

    public void setBarColor(int color) {
        this.barColor = color;
    }

    public void setBackColor(int color) {
        this.backColor = color;
    }

    public void setBorderColor(int color) {
        this.borderColor = color;
    }

    @Override
    public void vertical() {
        this.isVertical = true;
    }

    @Override
    public void reverse() {
        this.isReverse = true;
    }

    @Override
    public void setProgress(float progress) {
        this.progress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
    }

    public void noBorder() {
        this.border = false;
    }

    public void setBorderWidth(float borderX, float borderY) {
        this.borderX = borderX;
        this.borderY = borderY;
    }

    public BaseBarWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @Override
    public void renderBorder(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.border) {
            IUIGuiUtils.fillBorderRect(guiGraphics, this.getX(), this.getY(), this.width, this.height, this.borderX / (float)this.width / 2.0f, this.borderY / (float)this.height / 2.0f, this.borderColor);
        }
    }

    @Override
    public void renderBack(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        IUIGuiUtils.fill(guiGraphics, this.getX(), this.getY(), this.width, this.height, this.backColor);
    }

    @Override
    public void renderBar(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isVertical) {
            if (this.isReverse) {
                IUIGuiUtils.fill(guiGraphics, this.getX(), (float)(this.getY() + this.height) - (float)this.height * this.progress, this.width, (float)this.height * this.progress, this.barColor);
            } else {
                IUIGuiUtils.fill(guiGraphics, this.getX(), this.getY(), this.width, (float)this.height * this.progress, this.barColor);
            }
        } else if (this.isReverse) {
            IUIGuiUtils.fill(guiGraphics, (float)(this.getX() + this.width) - (float)this.width * this.progress, this.getY(), (float)this.width * this.progress, this.height, this.barColor);
        } else {
            IUIGuiUtils.fill(guiGraphics, this.getX(), this.getY(), (float)this.width * this.progress, this.height, this.barColor);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

