/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.bar.delay;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.bar.base.BaseTexBarWidget;

public class DelayTexBarWidget
extends BaseTexBarWidget {
    protected ResourceLocation delayIncreaseTex = null;
    protected ResourceLocation delayDecreaseTex = null;
    protected long delay = 500L;
    protected float startProgress = 0.0f;
    protected float targetProgress = 0.0f;
    protected long delayStartTime = 0L;

    public DelayTexBarWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @Override
    public void setTex(ResourceLocation tex) {
        super.setTex(tex);
        String namespace = tex.getNamespace();
        String path = tex.getPath();
        String replace = path.replace(".png", "");
        this.setDelayIncreaseTex(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(replace + "_bar_increase.png")));
        this.setDelayDecreaseTex(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(replace + "_bar_decrease.png")));
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setDelayIncreaseTex(ResourceLocation tex) {
        this.delayIncreaseTex = tex;
    }

    public void setDelayDecreaseTex(ResourceLocation tex) {
        this.delayDecreaseTex = tex;
    }

    protected boolean isIncrease() {
        return this.targetProgress > this.progress;
    }

    protected boolean isDecrease() {
        return this.targetProgress < this.progress;
    }

    @Override
    public void setProgress(float progress) {
        this.targetProgress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
        this.startProgress = this.progress;
        this.delayStartTime = System.currentTimeMillis();
    }

    protected void runDelay() {
        long currentTime = System.currentTimeMillis();
        if (this.delayStartTime == 0L) {
            return;
        }
        long elapsedTime = currentTime - this.delayStartTime;
        float progressDelta = (float)elapsedTime / (float)this.delay;
        if (this.isIncrease()) {
            this.progress = Mth.lerp((float)progressDelta, (float)this.startProgress, (float)this.targetProgress);
            if (this.progress >= this.targetProgress) {
                this.progress = this.targetProgress;
                this.delayStartTime = 0L;
            }
        } else if (this.isDecrease()) {
            this.progress = Mth.lerp((float)progressDelta, (float)this.startProgress, (float)this.targetProgress);
            if (this.progress <= this.targetProgress) {
                this.progress = this.targetProgress;
                this.delayStartTime = 0L;
            }
        }
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        this.runDelay();
        super.renderWidget(guiGraphics, i, i1, v);
    }

    @Override
    public void renderBeforeBar(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.delayIncreaseTex != null && this.isIncrease()) {
            if (this.isVertical) {
                if (this.isReverse) {
                    IUIGuiUtils.blit(guiGraphics, this.delayIncreaseTex, this.getX(), (float)(this.getY() + this.height) - (float)this.height * this.targetProgress, this.width, (float)this.height * this.targetProgress, 0.0f, 0.0f, this.getBarTexWidth(), (float)this.getBarTexHeight() * this.targetProgress, this.getBarTexWidth(), this.getBarTexHeight());
                } else {
                    IUIGuiUtils.blit(guiGraphics, this.delayIncreaseTex, this.getX(), this.getY(), this.width, (float)this.height * this.targetProgress, 0.0f, 0.0f, this.getBarTexWidth(), (float)this.getBarTexHeight() * this.targetProgress, this.getBarTexWidth(), this.getBarTexHeight());
                }
            } else if (this.isReverse) {
                IUIGuiUtils.blit(guiGraphics, this.delayIncreaseTex, (float)(this.getX() + this.width) - (float)this.width * this.targetProgress, this.getY(), (float)this.width * this.targetProgress, this.height, (float)this.width - (float)this.width * this.targetProgress, 0.0f, (float)this.getBarTexWidth() * this.targetProgress, this.getBarTexHeight(), this.getBarTexWidth(), this.getBarTexHeight());
            } else {
                IUIGuiUtils.blit(guiGraphics, this.delayIncreaseTex, this.getX(), this.getY(), (float)this.width * this.targetProgress, this.height, 0.0f, 0.0f, (float)this.getBarTexWidth() * this.targetProgress, this.getBarTexHeight(), this.getBarTexWidth(), this.getBarTexHeight());
            }
        }
    }

    @Override
    public void renderAfterBar(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.delayDecreaseTex != null && this.isDecrease()) {
            if (this.isVertical) {
                if (this.isReverse) {
                    IUIGuiUtils.blit(guiGraphics, this.delayDecreaseTex, this.getX(), (float)(this.getY() + this.height) - (float)this.height * this.progress, this.width, (float)this.height * (this.progress - this.targetProgress), 0.0f, 0.0f, this.getBarTexWidth(), (float)this.getBarTexHeight() * (this.progress - this.targetProgress), this.getBarTexWidth(), this.getBarTexHeight());
                } else {
                    IUIGuiUtils.blit(guiGraphics, this.delayDecreaseTex, this.getX(), (float)this.getY() + (float)this.height * this.targetProgress, this.width, (float)this.height * (this.progress - this.targetProgress), 0.0f, 0.0f, this.getBarTexWidth(), (float)this.getBarTexHeight() * (this.progress - this.targetProgress), this.getBarTexWidth(), this.getBarTexHeight());
                }
            } else if (this.isReverse) {
                IUIGuiUtils.blit(guiGraphics, this.delayDecreaseTex, (float)(this.getX() + this.width) - (float)this.width * this.progress, this.getY(), (float)this.width * (this.progress - this.targetProgress), this.height, (float)this.width - (float)this.width * this.targetProgress, 0.0f, (float)this.getBarTexWidth() * (this.progress - this.targetProgress), this.getBarTexHeight(), this.getBarTexWidth(), this.getBarTexHeight());
            } else {
                IUIGuiUtils.blit(guiGraphics, this.delayDecreaseTex, (float)this.getX() + (float)this.width * this.targetProgress, this.getY(), (float)this.width * (this.progress - this.targetProgress), this.height, 0.0f, 0.0f, (float)this.getBarTexWidth() * (this.progress - this.targetProgress), this.getBarTexHeight(), this.getBarTexWidth(), this.getBarTexHeight());
            }
        }
    }
}

