/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.bar.base;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.hiedacamellia.immersiveui.client.graphic.util.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.bar.AbstractBarWidget;

public class BaseTexBarWidget
extends AbstractBarWidget {
    protected float borderX = 1.0f;
    protected float borderY = 1.0f;
    protected boolean isVertical = false;
    protected boolean isReverse = false;
    protected float progress = 0.0f;
    protected ResourceLocation barTex = null;
    protected ResourceLocation backTex = null;
    protected ResourceLocation borderTex = null;

    public void setTex(ResourceLocation tex) {
        String namespace = tex.getNamespace();
        String path = tex.getPath();
        String replace = path.replace(".png", "");
        this.setBackTex(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(replace + "_back.png")));
        this.setBarTex(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(replace + "_bar.png")));
        this.setBorderTex(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(replace + "_border.png")));
    }

    public void setBarTex(ResourceLocation barTex) {
        this.barTex = barTex;
    }

    public void setBackTex(ResourceLocation backTex) {
        this.backTex = backTex;
    }

    public void setBorderTex(ResourceLocation borderTex) {
        this.borderTex = borderTex;
    }

    @Override
    public void vertical() {
        this.isVertical = true;
    }

    @Override
    public void reverse() {
        this.isReverse = true;
    }

    @Override
    public void setProgress(float progress) {
        this.progress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
    }

    public void setBorderWidth(float borderX, float borderY) {
        this.borderX = borderX;
        this.borderY = borderY;
    }

    public BaseTexBarWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @Override
    public void renderBorder(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.borderTex != null) {
            IUIGuiUtils.blit(guiGraphics, this.borderTex, this.getX(), this.getY(), this.getBorderTexWidth(), this.getBorderTexHeight());
        }
    }

    @Override
    public void renderBack(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.backTex != null) {
            IUIGuiUtils.blit(guiGraphics, this.backTex, this.getX(), this.getY(), this.getBackTexWidth(), this.getBackTexHeight());
        }
    }

    @Override
    public void renderBar(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.barTex != null) {
            if (this.isVertical) {
                if (this.isReverse) {
                    IUIGuiUtils.blit(guiGraphics, this.barTex, this.getX(), (float)(this.getY() + this.height) - (float)this.height * this.progress, this.width, (float)this.height * this.progress, 0.0f, 0.0f, this.getBarTexWidth(), (float)this.getBarTexHeight() * this.progress, this.getBarTexWidth(), this.getBarTexHeight());
                } else {
                    IUIGuiUtils.blit(guiGraphics, this.barTex, this.getX(), this.getY(), this.width, (float)this.height * this.progress, 0.0f, 0.0f, this.getBarTexWidth(), (float)this.getBarTexHeight() * this.progress, this.getBarTexWidth(), this.getBarTexHeight());
                }
            } else if (this.isReverse) {
                IUIGuiUtils.blit(guiGraphics, this.barTex, (float)(this.getX() + this.width) - (float)this.width * this.progress, this.getY(), (float)this.width * this.progress, this.height, (float)this.width - (float)this.width * this.progress, 0.0f, (int)((float)this.getBarTexWidth() * this.progress), this.getBarTexHeight(), this.getBarTexWidth(), this.getBarTexHeight());
            } else {
                IUIGuiUtils.blit(guiGraphics, this.barTex, this.getX(), this.getY(), (float)this.width * this.progress, this.height, 0.0f, 0.0f, (float)this.getBarTexWidth() * this.progress, this.getBarTexHeight(), this.getBarTexWidth(), this.getBarTexHeight());
            }
        }
    }

    protected int getBarTexHeight() {
        return this.height;
    }

    protected int getBarTexWidth() {
        return this.width;
    }

    protected int getBackTexHeight() {
        return this.height;
    }

    protected int getBackTexWidth() {
        return this.width;
    }

    protected int getBorderTexHeight() {
        return this.height;
    }

    protected int getBorderTexWidth() {
        return this.width;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

