/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.hiedacamellia.immersiveui.client.gui.component.widget.tree.TreeWidget;

public class TreeEntryWidget<T>
extends AbstractWidget {
    protected Font font;
    protected boolean fold = true;
    protected TreeEntryWidget<T> parent;
    protected List<TreeEntryWidget<T>> children = new ArrayList<TreeEntryWidget<T>>();
    protected T data;
    protected boolean isRoot = false;
    protected TreeWidget<T, TreeEntryWidget<T>> tree;
    protected int selfWidth;
    protected int selfHeight;
    protected int foldWidth;
    protected final Component foldComponent = Component.literal((String)"\u25b6");
    protected final Component unfoldComponent = Component.literal((String)"\u25bc");

    public void tree(TreeWidget<T, TreeEntryWidget<T>> tree) {
        this.isRoot = true;
        this.tree = tree;
    }

    public TreeWidget<T, TreeEntryWidget<T>> getTree() {
        if (this.isRoot) {
            return this.tree;
        }
        return this.parent.getTree();
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void insert(TreeEntryWidget<T> widget) {
        if (widget.isRoot()) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        if (this.parent == widget.parent) {
            this.parent.moveChild(widget, this.parent.children.indexOf((Object)this));
            return;
        }
        int i = this.parent.children.indexOf((Object)this);
        if (i == -1) {
            return;
        }
        widget.parent.removeChild(widget);
        this.parent.addChild(i, widget);
    }

    public TreeEntryWidget<T> getAt(double mouseX, double mouseY) {
        TreeEntryWidget<T> widget = this.getWidgetAt(mouseX, mouseY);
        if (widget == null) {
            return this.isHovered(mouseX, mouseY) ? this : null;
        }
        return widget.getAt(mouseX, mouseY);
    }

    public TreeEntryWidget<T> getWidgetAt(double mouseX, double mouseY) {
        if (this.fold) {
            return null;
        }
        for (TreeEntryWidget<T> child : this.children) {
            if (!child.isHovered(mouseX, mouseY)) continue;
            return child;
        }
        return null;
    }

    public boolean shouldAccept(double mouseX, double mouseY) {
        int x0 = this.getX();
        int y0 = this.getY();
        int x1 = x0 + this.foldWidth;
        int y1 = y0 + this.selfHeight;
        int x2 = x0 + this.foldWidth + this.selfWidth;
        return mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y0 && mouseY <= (double)y1;
    }

    public void accept(TreeEntryWidget<T> widget) {
        widget.parent.removeChild(widget);
        this.addChild(widget);
    }

    public TreeEntryWidget(Component message, Font font) {
        super(0, 0, 0, 0, message);
        this.font = font;
        Objects.requireNonNull(font);
        this.selfHeight = 9;
        this.selfWidth = font.width((FormattedText)message);
        this.foldWidth = font.width((FormattedText)this.foldComponent);
    }

    public static <T> TreeEntryWidget<T> of(T data, Component component, Font font) {
        TreeEntryWidget<T> widget = new TreeEntryWidget<T>(component, font);
        widget.setData(data);
        widget.width = widget.selfWidth;
        widget.height = widget.selfHeight;
        return widget;
    }

    public void addChild(int index, TreeEntryWidget<T> child) {
        this.children.add(index, child);
        child.parent = this;
        this.updateWidget();
    }

    public void addChild(TreeEntryWidget<T> child) {
        this.children.add(child);
        child.parent = this;
        this.updateWidget();
    }

    public void removeChild(TreeEntryWidget<T> child) {
        this.children.remove(child);
        child.parent = null;
        this.updateWidget();
    }

    public void moveChild(TreeEntryWidget<T> child, int index) {
        this.children.remove(child);
        this.children.add(index, child);
        this.updateWidget();
    }

    public boolean hasChild() {
        return !this.children.isEmpty();
    }

    public void setData(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public void fold() {
        this.fold = true;
        this.getTree().updateWidget();
    }

    public void unfold() {
        this.fold = false;
        this.getTree().updateWidget();
    }

    public void updateWidget() {
        int X = this.getX() + this.foldWidth;
        int Y = this.getY() + this.selfHeight;
        for (TreeEntryWidget<T> child : this.children) {
            child.setX(X);
            child.setY(Y);
            child.updateWidget();
            Y += child.getHeight();
        }
        this.updateHeight();
        this.updateWidth();
    }

    private void updateHeight() {
        int height = this.selfHeight;
        if (this.fold) {
            this.height = height;
            return;
        }
        for (AbstractWidget abstractWidget : this.children) {
            height += abstractWidget.getHeight();
        }
        this.height = height;
    }

    private void updateWidth() {
        int width = 0;
        if (this.hasChild()) {
            if (this.fold) {
                this.width = Math.max(width + this.foldWidth, this.foldWidth + this.selfWidth);
                return;
            }
            for (AbstractWidget abstractWidget : this.children) {
                width = Math.max(width, abstractWidget.getWidth());
            }
            this.width = Math.max(width + this.foldWidth, this.foldWidth + this.selfWidth);
        } else {
            this.width = this.selfWidth;
        }
    }

    public boolean shouldChangeFold(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int x0 = this.getX();
            int y0 = this.getY();
            int x1 = x0 + this.foldWidth;
            int y1 = y0 + this.selfHeight;
            return mouseX >= (double)x0 && mouseX <= (double)x1 && mouseY >= (double)y0 && mouseY <= (double)y1;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hasChild()) {
            TreeEntryWidget<T> child;
            if (this.shouldChangeFold(mouseX, mouseY, button)) {
                if (this.fold) {
                    this.unfold();
                } else {
                    this.fold();
                }
                return true;
            }
            if (this.isHovered(mouseX, mouseY) && button == 0) {
                return false;
            }
            if (!this.fold && (child = this.getWidgetAt(mouseX, mouseY)) != null) {
                boolean v = child.mouseClicked(mouseX, mouseY, button);
                this.updateWidget();
                return v;
            }
        } else if (button == 0) {
            return false;
        }
        return true;
    }

    public boolean isHovered(double mouseX, double mouseY) {
        int x0 = this.getX();
        int y0 = this.getY();
        int x1 = x0 + this.width;
        int y1 = y0 + this.height;
        return mouseX >= (double)x0 && mouseX <= (double)x1 && mouseY >= (double)y0 && mouseY <= (double)y1;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.hasChild()) {
            guiGraphics.drawString(this.font, (Component)(this.fold ? this.foldComponent.copy().append(this.getMessage()) : this.unfoldComponent.copy().append(this.getMessage())), this.getX(), this.getY(), 0xFFFFFF);
        } else {
            guiGraphics.drawString(this.font, this.getMessage(), this.getX(), this.getY(), 0xFFFFFF);
        }
        if (!this.getTree().isDrag(this)) {
            if (this.isHovered(mouseX, mouseY) && this.getTree().isDragging() && this.getWidgetAt(mouseX, mouseY) == null && !this.shouldAccept(mouseX, mouseY)) {
                guiGraphics.fill(this.getX(), this.getY() - 1, this.getTree().getX() + this.getTree().getWidth(), this.getY() + 2, -2130771968);
            }
            if (this.shouldAccept(mouseX, mouseY) && this.getTree().isDragging() && this.getWidgetAt(mouseX, mouseY) == null) {
                guiGraphics.fill(this.getX() + 4, this.getY() + 2, this.getTree().getX() + this.getTree().getWidth(), this.getY() + 7, -2147483393);
            }
        }
        if (this.fold) {
            return;
        }
        this.renderChildren(guiGraphics, mouseX, mouseY, v);
    }

    protected void renderChildren(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        for (TreeEntryWidget<T> child : this.children) {
            child.renderWidget(guiGraphics, mouseX, mouseY, v);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

