/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.animate;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimateUtils {

    public static class Time {
        public static float smooth(float time) {
            return 2.0f * time - time * time;
        }

        public static float bounce(float time) {
            return 4.0f * (time - time * time);
        }
    }

    public static class Lerp {
        public static double linear(double src, double dest, float time) {
            return src * (double)(1.0f - time) + dest * (double)time;
        }

        public static double smooth(double src, double dest, float time) {
            time = 2.0f * time - time * time;
            return src * (double)(1.0f - time) + dest * (double)time;
        }

        public static double sCurve(double src, double dest, float time) {
            float sqr = time * time;
            time = 3.0f * sqr - 2.0f * sqr * time;
            return src * (double)(1.0f - time) + dest * (double)time;
        }

        public static double bounce(double src, double dest, float time) {
            time = 2.0f * (time - time * time);
            return src * (double)(1.0f - time) + dest * (double)time;
        }
    }
}

