/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class RayTraceUtil {
    public static boolean isBlockedBySolidBlock(Level level, Vector3f start, Vector3f end, float step) {
        float distance = start.distanceSquared((Vector3fc)end);
        Vector3f direction = end.sub((Vector3fc)start).normalize();
        Vector3f current = start;
        double d = 0.0;
        while (d * d < (double)distance) {
            BlockPos pos = new BlockPos(Math.round(current.x), Math.round(current.y), Math.round(current.z));
            BlockState state = level.getBlockState(pos);
            if (state.isViewBlocking((BlockGetter)level, pos)) {
                return true;
            }
            current = current.add(direction.x * step, direction.y * step, direction.z * step);
            d += (double)step;
        }
        return false;
    }
}

