/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.graphic.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.hiedacamellia.immersiveui.client.graphic.shader.IUIShaders;
import org.joml.Matrix4f;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class IUIGuiUtils {
    public static void fillTriangle(GuiGraphics guiGraphics, float[] vertex, int color) {
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.addVertex(matrix4f, vertex[0], vertex[1], 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, vertex[2], vertex[3], 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, vertex[4], vertex[5], 0.0f).setColor(color);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void fillSquareCentered(GuiGraphics guiGraphics, float x, float y, float sideLength, int color) {
        IUIGuiUtils.fillCentered(guiGraphics, x, y, sideLength, sideLength, color);
    }

    public static void fillSquare(GuiGraphics guiGraphics, float x, float y, float sideLength, int color) {
        IUIGuiUtils.fill(guiGraphics, x, y, sideLength, sideLength, color);
    }

    public static void fillCentered(GuiGraphics guiGraphics, float x, float y, float width, float height, int color) {
        IUIGuiUtils.fill(guiGraphics, x - width / 2.0f, y - height / 2.0f, width, height, color);
    }

    public static void fill(GuiGraphics guiGraphics, float x, float y, float width, float height, int color) {
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        VertexConsumer bufferbuilder = guiGraphics.bufferSource().getBuffer(RenderType.gui());
        bufferbuilder.addVertex(matrix4f, x, y, 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x, y + height, 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x + width, y + height, 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x + width, y, 0.0f).setColor(color);
    }

    public static void fillRoundRectCentered(GuiGraphics guiGraphics, int x, int y, int width, int height, float radius, int color) {
        IUIGuiUtils.fillRoundRect(guiGraphics, x - width / 2, y - height / 2, width, height, radius, color);
    }

    public static void fillRoundRectCentered(GuiGraphics guiGraphics, int width, int height, float radius, int color) {
        IUIGuiUtils.fillRoundRect(guiGraphics, -width / 2, -height / 2, width, height, radius, color);
    }

    public static void fillRoundRect(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, int color) {
        IUIGuiUtils.fillRoundRect(guiGraphics.pose(), x, y, width, height, width > height ? (float)radius / (float)width : (float)radius / (float)height, color);
    }

    public static void fillRoundRect(GuiGraphics guiGraphics, int x, int y, int width, int height, float radius, int color) {
        IUIGuiUtils.fillRoundRect(guiGraphics.pose(), x, y, width, height, radius, color);
    }

    public static void fillRoundRect(PoseStack poseStack, int x, int y, int width, int height, float radius, int color) {
        IUIGuiUtils._fillRoundRect(poseStack, x, y, width, height, radius, color);
    }

    public static void _fillRoundRect(PoseStack poseStack, float x, float y, float width, float height, float radius, int color) {
        float x2 = x + width;
        float y2 = y + height;
        float ratio = height / width;
        RenderSystem.setShader(IUIShaders::getRoundRectShader);
        ShaderInstance shader = IUIShaders.getRoundRectShader();
        shader.safeGetUniform("Ratio").set(ratio);
        shader.safeGetUniform("Radius").set(radius);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, x, y, 0.0f).setUv(0.0f, 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x, y2, 0.0f).setUv(0.0f, 1.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x2, y2, 0.0f).setUv(1.0f, 1.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x2, y, 0.0f).setUv(1.0f, 0.0f).setColor(color);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void fillBorderRect(GuiGraphics guiGraphics, float x, float y, float width, float height, float radius, int color) {
        IUIGuiUtils._fillBorderRect(guiGraphics.pose(), x, y, width, height, radius, radius, color);
    }

    public static void fillBorderRect(PoseStack poseStack, float x, float y, float width, float height, float radius, int color) {
        IUIGuiUtils._fillBorderRect(poseStack, x, y, width, height, radius, radius, color);
    }

    public static void fillBorderRect(GuiGraphics guiGraphics, float x, float y, float width, float height, float radiusX, float radiusY, int color) {
        IUIGuiUtils._fillBorderRect(guiGraphics.pose(), x, y, width, height, radiusX, radiusY, color);
    }

    public static void _fillBorderRect(PoseStack poseStack, float x, float y, float width, float height, float radiusX, float radiusY, int color) {
        float x1 = x - width * radiusX;
        float y1 = y - height * radiusY;
        float x2 = x + width + width * radiusX;
        float y2 = y + height + height * radiusY;
        RenderSystem.setShader(IUIShaders::getBorderRectShader);
        ShaderInstance shader = IUIShaders.getBorderRectShader();
        shader.safeGetUniform("Radius").set(radiusX, radiusY);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, x1, y1, 0.0f).setUv(0.0f, 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x1, y2, 0.0f).setUv(0.0f, 1.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x2, y2, 0.0f).setUv(1.0f, 1.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x2, y1, 0.0f).setUv(1.0f, 0.0f).setColor(color);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void borderRoundRectCentered(GuiGraphics guiGraphics, int width, int height, float radius, int color, float borderThickness, int borderColor) {
        IUIGuiUtils.borderRoundRect(guiGraphics, -width / 2, -height / 2, width, height, radius, color, borderThickness, borderColor);
    }

    public static void borderRoundRect(GuiGraphics guiGraphics, int x, int y, int width, int height, float radius, int color, float borderThickness, int borderColor) {
        IUIGuiUtils.borderRoundRect(guiGraphics.pose(), x, y, width, height, radius, color, borderThickness, borderColor);
    }

    public static void borderRoundRect(PoseStack poseStack, int x, int y, int width, int height, float radius, int color, float borderThickness, int borderColor) {
        IUIGuiUtils._borderRoundRect(poseStack, x, y, width, height, radius, color, borderThickness, borderColor);
    }

    public static void _borderRoundRect(PoseStack poseStack, float x, float y, float width, float height, float radius, int color, float borderThickness, int borderColor) {
        float x2 = x + width;
        float y2 = y + height;
        float ratio = height / width;
        RenderSystem.setShader(IUIShaders::getBorderRoundRectShader);
        ShaderInstance shader = IUIShaders.getBorderRoundRectShader();
        shader.safeGetUniform("Ratio").set(ratio);
        shader.safeGetUniform("Radius").set(radius);
        shader.safeGetUniform("BorderThickness").set(borderThickness);
        Vector4f border = new Vector4f((float)FastColor.ARGB32.red((int)color), (float)FastColor.ARGB32.green((int)color), (float)FastColor.ARGB32.blue((int)color), (float)FastColor.ARGB32.alpha((int)color));
        shader.safeGetUniform("BorderColor").set(border);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, x, y, 0.0f).setUv(0.0f, 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x, y2, 0.0f).setUv(0.0f, 1.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x2, y2, 0.0f).setUv(1.0f, 1.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, x2, y, 0.0f).setUv(1.0f, 0.0f).setColor(color);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void blit(GuiGraphics guiGraphics, ResourceLocation location, int x, int y, int width, int height) {
        IUIGuiUtils.blit(guiGraphics.pose(), location, x, y, width, height);
    }

    public static void blit(PoseStack poseStack, ResourceLocation location, int x, int y, int width, int height) {
        IUIGuiUtils.blit(poseStack, location, (float)x, (float)y, (float)(x + width), (float)(y + height));
    }

    public static void blit(GuiGraphics guiGraphics, int textureId, int x, int y, int width, int height) {
        IUIGuiUtils.blit(guiGraphics.pose(), textureId, x, y, width, height);
    }

    public static void blit(PoseStack poseStack, int textureId, int x, int y, int width, int height) {
        IUIGuiUtils.blit(poseStack, textureId, (float)x, (float)y, (float)(x + width), (float)(y + height));
    }

    public static void blit(GuiGraphics guiGraphics, ResourceLocation location, float x1, float y1, float x2, float y2) {
        IUIGuiUtils.blit(guiGraphics.pose(), location, x1, y1, x2, y2, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void blit(PoseStack poseStack, ResourceLocation location, float x1, float y1, float x2, float y2) {
        IUIGuiUtils.blit(poseStack, location, x1, y1, x2, y2, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void blit(PoseStack poseStack, int textureId, float x1, float y1, float x2, float y2) {
        IUIGuiUtils.blit(poseStack, textureId, x1, y1, x2, y2, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void blit(PoseStack poseStack, ResourceLocation location, float x1, float y1, float x2, float y2, float u0, float v0, float u1, float v1) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        IUIGuiUtils._blit(poseStack, x1, y1, x2, y2, u0, v0, u1, v1);
    }

    public static void blit(PoseStack poseStack, int textureId, float x1, float y1, float x2, float y2, float u0, float v0, float u1, float v1) {
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        IUIGuiUtils._blit(poseStack, x1, y1, x2, y2, u0, v0, u1, v1);
    }

    public static void _blit(PoseStack poseStack, float x1, float y1, float x2, float y2, float u0, float v0, float u1, float v1) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, x1, y1, 0.0f).setUv(u0, v0);
        bufferbuilder.addVertex(matrix4f, x1, y2, 0.0f).setUv(u0, v1);
        bufferbuilder.addVertex(matrix4f, x2, y2, 0.0f).setUv(u1, v1);
        bufferbuilder.addVertex(matrix4f, x2, y1, 0.0f).setUv(u1, v0);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void blitInUv(PoseStack poseStack, ResourceLocation location, float x1, float y1, float x2, float y2, float u0, float v0, float u1, float v1) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        IUIGuiUtils._blitInUv(poseStack, x1, y1, x2, y2, u0, v0, u1, v1);
    }

    public static void blitInUv(PoseStack poseStack, int textureId, float x1, float y1, float x2, float y2, float u0, float v0, float u1, float v1) {
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        IUIGuiUtils._blitInUv(poseStack, x1, y1, x2, y2, u0, v0, u1, v1);
    }

    public static void _blitInUv(PoseStack poseStack, float x1, float y1, float x2, float y2, float u0, float v0, float u1, float v1) {
        RenderSystem.setShader(IUIShaders::getPositionTexShader);
        ShaderInstance shaderInstance = IUIShaders.getPositionTexShader();
        shaderInstance.safeGetUniform("uvCoords").set(u0, v0, u1, v1);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, x1, y1, 0.0f).setUv(0.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, x1, y2, 0.0f).setUv(0.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f, x2, y2, 0.0f).setUv(1.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f, x2, y1, 0.0f).setUv(1.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void blur(PoseStack poseStack, int textureId, float x1, float y1, float x2, float y2, float radius) {
        IUIGuiUtils.blur(poseStack, textureId, x1, y1, x2, y2, radius, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void blur(PoseStack poseStack, ResourceLocation atlasLocation, float x1, float y1, float x2, float y2, float radius) {
        IUIGuiUtils.blur(poseStack, atlasLocation, x1, y1, x2, y2, radius, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void blur(GuiGraphics guiGraphics, int textureId, float x1, float y1, float x2, float y2, float radius) {
        IUIGuiUtils.blur(guiGraphics.pose(), textureId, x1, y1, x2, y2, radius, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void blur(GuiGraphics guiGraphics, ResourceLocation atlasLocation, float x1, float y1, float x2, float y2, float radius) {
        IUIGuiUtils.blur(guiGraphics.pose(), atlasLocation, x1, y1, x2, y2, radius, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void blur(PoseStack poseStack, ResourceLocation atlasLocation, float x1, float y1, float x2, float y2, float radius, float u0, float v0, float u1, float v1) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        IUIGuiUtils._blur(poseStack, x1, y1, x2, y2, radius, u0, v0, u1, v1);
    }

    public static void blur(PoseStack poseStack, int textureId, float x1, float y1, float x2, float y2, float radius, float u0, float v0, float u1, float v1) {
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        IUIGuiUtils._blur(poseStack, x1, y1, x2, y2, radius, u0, v0, u1, v1);
    }

    private static void _blur(PoseStack poseStack, float x1, float y1, float x2, float y2, float radius, float u0, float v0, float u1, float v1) {
        RenderSystem.setShader(IUIShaders::getBlurShader);
        ShaderInstance shaderInstance = IUIShaders.getBlurShader();
        shaderInstance.safeGetUniform("Radius").set(radius);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, x1, y1, 0.0f).setUv(u0, v0);
        bufferbuilder.addVertex(matrix4f, x1, y2, 0.0f).setUv(u0, v1);
        bufferbuilder.addVertex(matrix4f, x2, y2, 0.0f).setUv(u1, v1);
        bufferbuilder.addVertex(matrix4f, x2, y1, 0.0f).setUv(u1, v0);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, String text, int x, int y, int color, boolean dropShadow) {
        float f = (float)x - (float)font.width(text) / 2.0f;
        float f2 = y;
        Objects.requireNonNull(font);
        IUIGuiUtils.drawString(guiGraphics, font, text, f, f2 - 9.0f / 2.0f, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color, boolean dropShadow) {
        FormattedCharSequence formattedcharsequence = text.getVisualOrderText();
        float f = (float)x - (float)font.width(formattedcharsequence) / 2.0f;
        float f2 = y;
        Objects.requireNonNull(font);
        IUIGuiUtils.drawString(guiGraphics, font, formattedcharsequence, f, f2 - 9.0f / 2.0f, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, FormattedCharSequence text, int x, int y, int color, boolean dropShadow) {
        float f = (float)x - (float)font.width(text) / 2.0f;
        float f2 = y;
        Objects.requireNonNull(font);
        IUIGuiUtils.drawString(guiGraphics, font, text, f, f2 - 9.0f / 2.0f, color, dropShadow);
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, FormattedCharSequence text, float x, float y, int color, boolean dropShadow) {
        return guiGraphics.drawString(font, text, x, y, color, dropShadow);
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, @Nullable String text, float x, float y, int color, boolean s) {
        return guiGraphics.drawString(font, text, x, y, color, s);
    }

    public static void drawRing(GuiGraphics guiGraphics, int x, int y, float innerRadius, float outerRadius, float startAngle, float endAngle, int color) {
        IUIGuiUtils.drawRing(guiGraphics, x, y, innerRadius, outerRadius, startAngle, endAngle, color, color);
    }

    public static void drawRing(GuiGraphics guiGraphics, int x, int y, float innerRadius, float outerRadius, float startAngle, float endAngle, int color, float smooth) {
        IUIGuiUtils.drawRing(guiGraphics, x, y, innerRadius, outerRadius, startAngle, endAngle, color, color, smooth);
    }

    public static void drawRing(GuiGraphics guiGraphics, int x, int y, float innerRadius, float outerRadius, float startAngle, float endAngle, int innerColor, int outerColor) {
        IUIGuiUtils.drawRing(guiGraphics, x, y, innerRadius, outerRadius, startAngle, endAngle, innerColor, outerColor, 0.5f / outerRadius);
    }

    public static void drawRing(GuiGraphics guiGraphics, int x, int y, float innerRadius, float outerRadius, float startAngle, float endAngle, int innerColor, int outerColor, float smooth) {
        float x2 = (float)x + outerRadius;
        float y2 = (float)y + outerRadius;
        float x1 = (float)x - outerRadius;
        float y1 = (float)y - outerRadius;
        RenderSystem.setShader(IUIShaders::getRingShader);
        ShaderInstance shader = IUIShaders.getRingShader();
        shader.safeGetUniform("innerRadius").set(innerRadius / outerRadius / 2.0f);
        shader.safeGetUniform("outerRadius").set(0.5f);
        shader.safeGetUniform("innerColor").set(IUIGuiUtils.int2vec4(innerColor));
        shader.safeGetUniform("outerColor").set(IUIGuiUtils.int2vec4(outerColor));
        shader.safeGetUniform("startAngle").set(startAngle);
        shader.safeGetUniform("endAngle").set(endAngle);
        shader.safeGetUniform("Smooth").set(smooth);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, x1, y1, 0.0f).setUv(0.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f, x1, y2, 0.0f).setUv(0.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, x2, y2, 0.0f).setUv(1.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, x2, y1, 0.0f).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void blitRoundCentered(GuiGraphics guiGraphics, ResourceLocation resourceLocation, float x, float y, int radius, float smooth) {
        float x1 = x - (float)radius;
        float y1 = y - (float)radius;
        float x2 = x + (float)radius;
        float y2 = y + (float)radius;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.setShader(IUIShaders::getRoundShader);
        ShaderInstance shader = IUIShaders.getRoundShader();
        shader.safeGetUniform("Smooth").set(smooth);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, x1, y1, 0.0f).setUv(0.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f, x1, y2, 0.0f).setUv(0.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, x2, y2, 0.0f).setUv(1.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, x2, y1, 0.0f).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    private static Vector4f int2vec4(int color) {
        return new Vector4f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
    }
}

