/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.bar.base;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.hiedacamellia.immersiveui.client.graphic.gui.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.bar.base.IBarWidget;

public class BaseTexBarWidget
extends AbstractWidget
implements IBarWidget {
    protected float borderX = 1.0f;
    protected float borderY = 1.0f;
    protected boolean isVertical = false;
    protected boolean isReverse = false;
    protected float progress = 0.0f;
    protected ResourceLocation barTex = null;
    protected ResourceLocation backTex = null;
    protected ResourceLocation borderTex = null;

    public void setTex(ResourceLocation tex) {
        String namespace = tex.getNamespace();
        String path = tex.getPath();
        String replace = path.replace(".png", "");
        this.setBackTex(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(replace + "_back.png")));
        this.setBarTex(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(replace + "_bar.png")));
        this.setBorderTex(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(replace + "_border.png")));
    }

    public void setBarTex(ResourceLocation barTex) {
        this.barTex = barTex;
    }

    public void setBackTex(ResourceLocation backTex) {
        this.backTex = backTex;
    }

    public void setBorderTex(ResourceLocation borderTex) {
        this.borderTex = borderTex;
    }

    @Override
    public void vertical() {
        this.isVertical = true;
    }

    @Override
    public void reverse() {
        this.isReverse = true;
    }

    @Override
    public void setProgress(float progress) {
        this.progress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
    }

    public void setBorderWidth(float borderX, float borderY) {
        this.borderX = borderX;
        this.borderY = borderY;
    }

    public BaseTexBarWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        int x = this.getX();
        int y = this.getY();
        if (this.backTex != null) {
            IUIGuiUtils.blit(guiGraphics, this.backTex, x, y, this.width, this.height);
        }
        if (this.barTex != null) {
            if (this.isVertical) {
                if (this.isReverse) {
                    guiGraphics.blit(this.barTex, x, (int)((float)(y + this.height) - (float)this.height * this.progress), this.width, (int)((float)this.height * this.progress), 0.0f, 0.0f, this.width, (int)((float)this.height * this.progress), this.width, this.height);
                } else {
                    guiGraphics.blit(this.barTex, x, y, this.width, (int)((float)this.height * this.progress), 0.0f, 0.0f, this.width, (int)((float)this.height * this.progress), this.width, this.height);
                }
            } else if (this.isReverse) {
                guiGraphics.blit(this.barTex, (int)((float)(x + this.width) - (float)this.width * this.progress), y, (int)((float)this.width * this.progress), this.height, (float)this.width - (float)this.width * this.progress, 0.0f, (int)((float)this.width * this.progress), this.height, this.width, this.height);
            } else {
                guiGraphics.blit(this.barTex, x, y, (int)((float)this.width * this.progress), this.height, 0.0f, 0.0f, (int)((float)this.width * this.progress), this.height, this.width, this.height);
            }
        }
        if (this.borderTex != null) {
            IUIGuiUtils.blit(guiGraphics, this.borderTex, x, y, this.width, this.height);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

