/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.bar.base;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.hiedacamellia.immersiveui.client.graphic.gui.IUIGuiUtils;
import org.hiedacamellia.immersiveui.client.gui.component.widget.bar.base.IBarWidget;

public class BaseBarWidget
extends AbstractWidget
implements IBarWidget {
    protected float borderX = 1.0f;
    protected float borderY = 1.0f;
    protected boolean isVertical = false;
    protected boolean isReverse = false;
    protected float progress = 0.0f;
    protected boolean border = true;
    protected int barColor = -1;
    protected int backColor = -1;
    protected int borderColor = -65536;

    public void setBarColor(int color) {
        this.barColor = color;
    }

    public void setBackColor(int color) {
        this.backColor = color;
    }

    public void setBorderColor(int color) {
        this.borderColor = color;
    }

    @Override
    public void vertical() {
        this.isVertical = true;
    }

    @Override
    public void reverse() {
        this.isReverse = true;
    }

    @Override
    public void setProgress(float progress) {
        this.progress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
    }

    public void noBorder() {
        this.border = false;
    }

    public void setBorderWidth(float borderX, float borderY) {
        this.borderX = borderX;
        this.borderY = borderY;
    }

    public BaseBarWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        int x = this.getX();
        int y = this.getY();
        IUIGuiUtils.fill(guiGraphics, x, y, this.width, this.height, this.backColor);
        if (this.isVertical) {
            if (this.isReverse) {
                IUIGuiUtils.fill(guiGraphics, x, (float)(y + this.height) - (float)this.height * this.progress, this.width, (float)this.height * this.progress, this.barColor);
            } else {
                IUIGuiUtils.fill(guiGraphics, x, y, this.width, (float)this.height * this.progress, this.barColor);
            }
        } else if (this.isReverse) {
            IUIGuiUtils.fill(guiGraphics, (float)(x + this.width) - (float)this.width * this.progress, y, (float)this.width * this.progress, this.height, this.barColor);
        } else {
            IUIGuiUtils.fill(guiGraphics, x, y, (float)this.width * this.progress, this.height, this.barColor);
        }
        if (this.border) {
            IUIGuiUtils.fillBorderRect(guiGraphics, x, y, this.width, this.height, this.borderX / (float)this.width / 2.0f, this.borderY / (float)this.height / 2.0f, this.borderColor);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

