/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.transaction.impl;

import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.transaction.impl.Neo4jJtaTransactionCoordinator;
import org.hibernate.ogm.datastore.neo4j.transaction.impl.Neo4jLocalTransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;

public class Neo4jTransactionCoordinatorBuilder
implements TransactionCoordinatorBuilder {
    private final TransactionCoordinatorBuilder delegate;
    private final Neo4jDatastoreProvider datastoreProvider;

    public Neo4jTransactionCoordinatorBuilder(TransactionCoordinatorBuilder delegate, Neo4jDatastoreProvider datastoreProvider) {
        this.delegate = delegate;
        this.datastoreProvider = datastoreProvider;
    }

    public TransactionCoordinator buildTransactionCoordinator(TransactionCoordinatorOwner owner, TransactionCoordinatorBuilder.TransactionCoordinatorOptions options) {
        TransactionCoordinator coordinator = this.delegate.buildTransactionCoordinator(owner, options);
        if (this.delegate.isJta()) {
            return new Neo4jJtaTransactionCoordinator(coordinator, this.datastoreProvider);
        }
        return new Neo4jLocalTransactionCoordinator(coordinator, this.datastoreProvider);
    }

    public boolean isJta() {
        return this.delegate.isJta();
    }

    public ConnectionReleaseMode getDefaultConnectionReleaseMode() {
        return this.delegate.getDefaultConnectionReleaseMode();
    }

    public ConnectionAcquisitionMode getDefaultConnectionAcquisitionMode() {
        return this.delegate.getDefaultConnectionAcquisitionMode();
    }
}

