/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl;

import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;

public class Neo4jComparisonPredicate
extends ComparisonPredicate<StringBuilder>
implements NegatablePredicate<StringBuilder> {
    private final String alias;
    private final StringBuilder builder;

    public Neo4jComparisonPredicate(StringBuilder builder, String alias, String propertyName, ComparisonPredicate.Type comparisonType, Object value) {
        super(propertyName, comparisonType, value);
        this.builder = builder;
        this.alias = alias;
    }

    protected StringBuilder getStrictlyLessQuery() {
        return this.comparison("<");
    }

    protected StringBuilder getLessOrEqualsQuery() {
        return this.comparison("<=");
    }

    protected StringBuilder getEqualsQuery() {
        return this.comparison("=");
    }

    private StringBuilder getNotEqualsQuery() {
        return this.comparison("<>");
    }

    protected StringBuilder getGreaterOrEqualsQuery() {
        return this.comparison(">=");
    }

    protected StringBuilder getStrictlyGreaterQuery() {
        return this.comparison(">");
    }

    public StringBuilder getNegatedQuery() {
        switch (this.type) {
            case LESS: {
                return this.getGreaterOrEqualsQuery();
            }
            case LESS_OR_EQUAL: {
                return this.getStrictlyGreaterQuery();
            }
            case EQUALS: {
                return this.getNotEqualsQuery();
            }
            case GREATER_OR_EQUAL: {
                return this.getStrictlyLessQuery();
            }
            case GREATER: {
                return this.getLessOrEqualsQuery();
            }
        }
        throw new UnsupportedOperationException("Unsupported comparison type: " + this.type);
    }

    private StringBuilder comparison(String operator) {
        return CypherDSL.compare(CypherDSL.identifier(this.builder, this.alias, this.propertyName), operator, this.value);
    }
}

