/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.BaseSchemaDefiner;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;
import org.jboss.logging.Logger;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;

public class Neo4jSchemaDefiner
extends BaseSchemaDefiner {
    private static final Log log = LoggerFactory.getLogger();

    public void initializeSchema(Configuration configuration, SessionFactoryImplementor factory) {
        SessionFactoryImplementor sessionFactoryImplementor = factory;
        ServiceRegistryImplementor registry = sessionFactoryImplementor.getServiceRegistry();
        Neo4jDatastoreProvider provider = (Neo4jDatastoreProvider)registry.getService(DatastoreProvider.class);
        this.createSequences(sessionFactoryImplementor, provider);
        this.createEntityConstraints(provider.getDataBase(), configuration);
    }

    private void createSequences(SessionFactoryImplementor sessionFactoryImplementor, Neo4jDatastoreProvider provider) {
        Set sequences = this.getPersistentGenerators(sessionFactoryImplementor);
        provider.getSequenceGenerator().createSequences(sequences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEntityConstraints(GraphDatabaseService neo4jDb, Configuration configuration) {
        UniqueConstraintSchemaUpdateStrategy constraintMethod = UniqueConstraintSchemaUpdateStrategy.interpret((Object)configuration.getProperties().get("hibernate.schema_update.unique_constraint_strategy"));
        log.debugf("%1$s property set to %2$s", "hibernate.schema_update.unique_constraint_strategy", constraintMethod);
        if (constraintMethod == UniqueConstraintSchemaUpdateStrategy.SKIP) {
            log.tracef("Skipping generation of unique constraints", new Object[0]);
        } else {
            log.debug("Creating missing constraints");
            Transaction tx = null;
            try {
                tx = neo4jDb.beginTx();
                this.addUniqueConstraints(neo4jDb, configuration);
                tx.success();
            }
            finally {
                tx.close();
            }
        }
    }

    private void addUniqueConstraints(GraphDatabaseService neo4jDb, Configuration configuration) {
        Iterator tableMappings = configuration.getTableMappings();
        while (tableMappings.hasNext()) {
            Table table = (Table)tableMappings.next();
            if (!table.isPhysicalTable()) continue;
            Label label = DynamicLabel.label((String)table.getName());
            PrimaryKey primaryKey = table.getPrimaryKey();
            this.createConstraint(neo4jDb, table, label, (Constraint)primaryKey);
            Iterator columnIterator = table.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                if (!column.isUnique()) continue;
                this.createUniqueConstraintIfMissing(neo4jDb, label, column.getName());
            }
            Iterator uniqueKeyIterator = table.getUniqueKeyIterator();
            while (uniqueKeyIterator.hasNext()) {
                this.createConstraint(neo4jDb, table, label, (Constraint)uniqueKeyIterator.next());
            }
        }
    }

    private void createConstraint(GraphDatabaseService neo4jDb, Table table, Label label, Constraint constraint) {
        if (constraint != null && !this.isAppliedToForeignColumns(table, constraint)) {
            if (constraint.getColumnSpan() == 1) {
                String propertyName = constraint.getColumn(0).getName();
                this.createUniqueConstraintIfMissing(neo4jDb, label, propertyName);
            } else if (log.isEnabled(Logger.Level.WARN)) {
                this.logMultipleColumnsWarning(table, constraint);
            }
        }
    }

    private boolean isAppliedToForeignColumns(Table table, Constraint constraint) {
        List constraintColumns = constraint.getColumns();
        Iterator iterator = table.getForeignKeyIterator();
        while (iterator.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)iterator.next();
            List foreignKeyColumns = foreignKey.getColumns();
            for (Object object : foreignKeyColumns) {
                if (!constraintColumns.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    private void logMultipleColumnsWarning(Table table, Constraint constraint) {
        StringBuilder builder = new StringBuilder();
        Iterator columnIterator = constraint.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column column = (Column)columnIterator.next();
            builder.append(", ");
            builder.append(column.getName());
        }
        String columns = "[" + builder.substring(2) + "]";
        log.constraintSpanningMultipleColumns(constraint.getName(), table.getName(), columns);
    }

    private void createUniqueConstraintIfMissing(GraphDatabaseService neo4jDb, Label label, String property) {
        if (this.isMissingUniqueConstraint(neo4jDb, label, property)) {
            log.tracef("Creating unique constraint for nodes labeled as %1$s on property %2$s", label, property);
            neo4jDb.schema().constraintFor(label).assertPropertyIsUnique(property).create();
        } else {
            log.tracef("Unique constraint already exists for nodes labeled as %1$s on property %2$s", label, property);
        }
    }

    private boolean isMissingUniqueConstraint(GraphDatabaseService neo4jDb, Label label, String propertyName) {
        Iterable constraints = neo4jDb.schema().getConstraints(label);
        for (ConstraintDefinition constraint : constraints) {
            if (!constraint.isConstraintType(ConstraintType.UNIQUENESS)) continue;
            for (String propertyKey : constraint.getPropertyKeys()) {
                if (!propertyKey.equals(propertyName)) continue;
                return false;
            }
        }
        return true;
    }
}

