/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Collection;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.IoThroughputStat;
import org.neo4j.unsafe.impl.batchimport.staging.AbstractStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public abstract class ProducerStep
extends AbstractStep<Void>
implements StatsProvider {
    protected final int batchSize;

    public ProducerStep(StageControl control, Configuration config) {
        super(control, ">", config, new StatsProvider[0]);
        this.batchSize = config.batchSize();
    }

    @Override
    public long receive(long ticket, Void batch) {
        new Thread(this.name()){

            @Override
            public void run() {
                ProducerStep.this.assertHealthy();
                try {
                    ProducerStep.this.process();
                    ProducerStep.this.endOfUpstream();
                }
                catch (Throwable e) {
                    ProducerStep.this.issuePanic(e, false);
                }
            }
        }.start();
        return 0L;
    }

    protected abstract void process();

    protected void sendDownstream(Object batch) {
        long time = this.downstream.receive(this.doneBatches.getAndIncrement(), batch);
        this.downstreamIdleTime.add(time);
    }

    @Override
    protected void collectStatsProviders(Collection<StatsProvider> into) {
        super.collectStatsProviders(into);
        into.add(this);
    }

    @Override
    public Stat stat(Key key) {
        if (key == Keys.io_throughput) {
            return new IoThroughputStat(this.startTime, this.endTime, this.position());
        }
        return null;
    }

    @Override
    public Key[] keys() {
        return new Key[]{Keys.io_throughput};
    }

    protected abstract long position();
}

