/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public class DynamicProcessorAssigner
extends ExecutionMonitor.Adapter {
    private final Configuration config;
    private final Map<Step<?>, Long> lastChangedProcessors = new HashMap();
    private final int availableProcessors;

    public DynamicProcessorAssigner(Configuration config) {
        super(100L, TimeUnit.MILLISECONDS);
        this.config = config;
        this.availableProcessors = config.maxNumberOfProcessors();
    }

    @Override
    public void start(StageExecution execution) {
        this.lastChangedProcessors.clear();
    }

    @Override
    public void check(StageExecution execution) {
        if (execution.stillExecuting()) {
            int permits = this.availableProcessors - this.countActiveProcessors(execution);
            if (permits > 0) {
                this.assignProcessorsToPotentialBottleNeck(execution, permits);
            }
            this.removeProcessorFromPotentialIdleStep(execution);
        }
    }

    private void assignProcessorsToPotentialBottleNeck(StageExecution execution, int permits) {
        Pair<Step<?>, Float> bottleNeck = execution.stepsOrderedBy(Keys.avg_processing_time, false).iterator().next();
        Step bottleNeckStep = (Step)bottleNeck.first();
        long doneBatches = this.batches(bottleNeckStep);
        if (((Float)bottleNeck.other()).floatValue() > 1.0f && this.batchesPassedSinceLastChange(bottleNeckStep, doneBatches) >= (long)this.config.movingAverageSize()) {
            int optimalProcessorIncrement = Integer.min(Math.max(1, (int)((Float)bottleNeck.other()).floatValue() - 1), permits);
            int before = bottleNeckStep.processors(0);
            int after = bottleNeckStep.processors(Math.max(optimalProcessorIncrement, permits / 10));
            if (after > before) {
                this.lastChangedProcessors.put(bottleNeckStep, doneBatches);
            }
        }
    }

    private void removeProcessorFromPotentialIdleStep(StageExecution execution) {
        for (Pair<Step<?>, Float> fast : execution.stepsOrderedBy(Keys.avg_processing_time, true)) {
            long doneBatches;
            Step fastestStep;
            float factorWithDecrementedProcessorCount;
            int numberOfProcessors = ((Step)fast.first()).processors(0);
            if (numberOfProcessors == 1 || !((factorWithDecrementedProcessorCount = ((Float)fast.other()).floatValue() * (float)numberOfProcessors / (float)(numberOfProcessors - 1)) < 0.8f) || this.batchesPassedSinceLastChange(fastestStep = (Step)fast.first(), doneBatches = this.batches(fastestStep)) < (long)this.config.movingAverageSize()) continue;
            int before = fastestStep.processors(0);
            if (fastestStep.processors(-1) >= before) continue;
            this.lastChangedProcessors.put(fastestStep, doneBatches);
            return;
        }
    }

    private long avg(Step<?> step) {
        return step.stats().stat(Keys.avg_processing_time).asLong();
    }

    private long batches(Step<?> step) {
        return step.stats().stat(Keys.done_batches).asLong();
    }

    private int countActiveProcessors(StageExecution execution) {
        float processors = 0.0f;
        if (execution.stillExecuting()) {
            long highestAverage = this.avg((Step)execution.stepsOrderedBy(Keys.avg_processing_time, false).iterator().next().first());
            for (Step<?> step : execution.steps()) {
                long avg = this.avg(step);
                float factor = (float)avg / (float)highestAverage;
                processors += factor * (float)step.processors(0);
            }
        }
        return Math.round(processors);
    }

    private long batchesPassedSinceLastChange(Step<?> step, long doneBatches) {
        return this.lastChangedProcessors.containsKey(step) ? doneBatches - this.lastChangedProcessors.get(step) : (long)this.config.movingAverageSize();
    }
}

