/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.UpdateBehaviour;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputNodeDeserialization;

public class ExternalPropertiesDecorator
implements Decorator<InputNode> {
    private final InputEntityDeserializer<InputNode> deserializer;
    private final UpdateBehaviour updateBehaviour;
    private InputNode currentExternal;

    public ExternalPropertiesDecorator(DataFactory<InputNode> data, Header.Factory headerFactory, Configuration config, IdType idType, UpdateBehaviour updateBehaviour, Collector badCollector) {
        this.updateBehaviour = updateBehaviour;
        CharSeeker dataStream = CharSeekers.charSeeker((CharReadable)data.create(config).stream(), (org.neo4j.csv.reader.Configuration)config, (boolean)true);
        Header header = headerFactory.create(dataStream, config, idType);
        this.deserializer = new InputEntityDeserializer<InputNode>(header, dataStream, config.delimiter(), new InputNodeDeserialization(header, (SourceTraceability)dataStream, new Groups(), idType.idsAreExternal()), InputEntityDecorators.NO_NODE_DECORATOR, Validators.emptyValidator(), badCollector);
    }

    @Override
    public InputNode apply(InputNode from) throws RuntimeException {
        Object id = from.id();
        if (this.currentExternal != null) {
            if (id.equals(this.currentExternal.id())) {
                this.decorate(from);
                this.currentExternal = null;
            } else {
                return from;
            }
        }
        while (this.deserializer.hasNext()) {
            this.currentExternal = (InputNode)this.deserializer.next();
            if (!id.equals(this.currentExternal.id())) break;
            this.decorate(from);
        }
        return from;
    }

    private void decorate(InputNode from) {
        from.updateProperties(this.updateBehaviour, this.currentExternal.properties());
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public void close() {
        this.deserializer.close();
    }
}

