/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheNumberArray;

public class PageCacheIntArray
extends PageCacheNumberArray<IntArray>
implements IntArray {
    PageCacheIntArray(PagedFile pagedFile, long length, long defaultValue, long base) throws IOException {
        super(pagedFile, 4, length, defaultValue | defaultValue << 32, base);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int get(long index) {
        long pageId = this.pageId(index);
        int offset = this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            int result;
            cursor.next();
            do {
                result = cursor.getInt(offset);
            } while (cursor.shouldRetry());
            this.checkBounds(cursor);
            int n = result;
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void set(long index, int value) {
        long pageId = this.pageId(index);
        int offset = this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putInt(offset, value);
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

