/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.kernel.impl.transaction.command.Command;

public enum TransactionApplicationMode {
    INTERNAL(false, false, false, true, Command.Version.AFTER),
    EXTERNAL(true, true, false, true, Command.Version.AFTER),
    RECOVERY(true, false, true, true, Command.Version.AFTER),
    REVERSE_RECOVERY(false, false, true, false, Command.Version.BEFORE);

    private final boolean needsHighIdTracking;
    private final boolean needsCacheInvalidation;
    private final boolean needsIdempotencyChecks;
    private final boolean indexesAndCounts;
    private final Command.Version version;

    private TransactionApplicationMode(boolean needsHighIdTracking, boolean needsCacheInvalidation, boolean ensureIdempotency, boolean indexesAndCounts, Command.Version version) {
        this.needsHighIdTracking = needsHighIdTracking;
        this.needsCacheInvalidation = needsCacheInvalidation;
        this.needsIdempotencyChecks = ensureIdempotency;
        this.indexesAndCounts = indexesAndCounts;
        this.version = version;
    }

    public boolean needsHighIdTracking() {
        return this.needsHighIdTracking;
    }

    public boolean needsCacheInvalidationOnUpdates() {
        return this.needsCacheInvalidation;
    }

    public boolean needsIdempotencyChecks() {
        return this.needsIdempotencyChecks;
    }

    public boolean needsAuxiliaryStores() {
        return this.indexesAndCounts;
    }

    public Command.Version version() {
        return this.version;
    }
}

