/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailScanner;

public class PositionToRecoverFrom
implements ThrowingSupplier<LogPosition, IOException> {
    public static final Monitor NO_MONITOR = new Monitor(){};
    private final LogTailScanner logTailScanner;
    private final Monitor monitor;

    public PositionToRecoverFrom(LogTailScanner logTailScanner, Monitor monitor) {
        this.logTailScanner = logTailScanner;
        this.monitor = monitor;
    }

    public LogPosition get() throws IOException {
        LogTailScanner.LogTailInformation logTailInformation = this.logTailScanner.getTailInformation();
        if (!logTailInformation.commitsAfterLastCheckPoint) {
            this.monitor.noCommitsAfterLastCheckPoint(logTailInformation.lastCheckPoint != null ? logTailInformation.lastCheckPoint.getLogPosition() : null);
            return LogPosition.UNSPECIFIED;
        }
        if (logTailInformation.lastCheckPoint != null) {
            this.monitor.commitsAfterLastCheckPoint(logTailInformation.lastCheckPoint.getLogPosition(), logTailInformation.firstTxIdAfterLastCheckPoint);
            return logTailInformation.lastCheckPoint.getLogPosition();
        }
        if (logTailInformation.oldestLogVersionFound != 0L) {
            long fromLogVersion = Math.max(0L, logTailInformation.oldestLogVersionFound);
            throw new UnderlyingStorageException("No check point found in any log file from version " + fromLogVersion + " to " + logTailInformation.currentLogVersion);
        }
        this.monitor.noCheckPointFound();
        return LogPosition.start(0L);
    }

    public static interface Monitor {
        default public void noCommitsAfterLastCheckPoint(LogPosition logPosition) {
        }

        default public void commitsAfterLastCheckPoint(LogPosition logPosition, long firstTxIdAfterLastCheckPoint) {
        }

        default public void noCheckPointFound() {
        }
    }
}

