/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import java.util.function.Supplier;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.BranchCollisionPolicies;
import org.neo4j.graphdb.traversal.BranchCollisionPolicy;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.SideSelectorPolicies;
import org.neo4j.graphdb.traversal.SideSelectorPolicy;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.kernel.impl.traversal.BidirectionalTraverserIterator;
import org.neo4j.kernel.impl.traversal.DefaultTraverser;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.impl.traversal.TraverserIterator;

public class BidirectionalTraversalDescriptionImpl
implements BidirectionalTraversalDescription {
    final MonoDirectionalTraversalDescription start;
    final MonoDirectionalTraversalDescription end;
    final PathEvaluator collisionEvaluator;
    final SideSelectorPolicy sideSelector;
    final BranchCollisionPolicy collisionPolicy;
    final Supplier<? extends Resource> statementFactory;
    final int maxDepth;

    private BidirectionalTraversalDescriptionImpl(MonoDirectionalTraversalDescription start, MonoDirectionalTraversalDescription end, BranchCollisionPolicy collisionPolicy, PathEvaluator collisionEvaluator, SideSelectorPolicy sideSelector, Supplier<? extends Resource> statementFactory, int maxDepth) {
        this.start = start;
        this.end = end;
        this.collisionPolicy = collisionPolicy;
        this.collisionEvaluator = collisionEvaluator;
        this.sideSelector = sideSelector;
        this.statementFactory = statementFactory;
        this.maxDepth = maxDepth;
    }

    public BidirectionalTraversalDescriptionImpl(Supplier<? extends Resource> statementFactory) {
        this(new MonoDirectionalTraversalDescription(), new MonoDirectionalTraversalDescription(), (BranchCollisionPolicy)BranchCollisionPolicies.STANDARD, Evaluators.all(), (SideSelectorPolicy)SideSelectorPolicies.ALTERNATING, statementFactory, Integer.MAX_VALUE);
    }

    public BidirectionalTraversalDescriptionImpl() {
        this(MonoDirectionalTraversalDescription.NO_STATEMENT);
    }

    public BidirectionalTraversalDescription startSide(TraversalDescription startSideDescription) {
        this.assertIsMonoDirectional(startSideDescription);
        return new BidirectionalTraversalDescriptionImpl((MonoDirectionalTraversalDescription)startSideDescription, this.end, this.collisionPolicy, this.collisionEvaluator, this.sideSelector, this.statementFactory, this.maxDepth);
    }

    public BidirectionalTraversalDescription endSide(TraversalDescription endSideDescription) {
        this.assertIsMonoDirectional(endSideDescription);
        return new BidirectionalTraversalDescriptionImpl(this.start, (MonoDirectionalTraversalDescription)endSideDescription, this.collisionPolicy, this.collisionEvaluator, this.sideSelector, this.statementFactory, this.maxDepth);
    }

    public BidirectionalTraversalDescription mirroredSides(TraversalDescription sideDescription) {
        this.assertIsMonoDirectional(sideDescription);
        return new BidirectionalTraversalDescriptionImpl((MonoDirectionalTraversalDescription)sideDescription, (MonoDirectionalTraversalDescription)sideDescription.reverse(), this.collisionPolicy, this.collisionEvaluator, this.sideSelector, this.statementFactory, this.maxDepth);
    }

    public BidirectionalTraversalDescription collisionPolicy(BranchCollisionPolicy collisionPolicy) {
        return new BidirectionalTraversalDescriptionImpl(this.start, this.end, collisionPolicy, this.collisionEvaluator, this.sideSelector, this.statementFactory, this.maxDepth);
    }

    public BidirectionalTraversalDescription collisionEvaluator(PathEvaluator collisionEvaluator) {
        MonoDirectionalTraversalDescription.nullCheck(collisionEvaluator, Evaluator.class, "RETURN_ALL");
        return new BidirectionalTraversalDescriptionImpl(this.start, this.end, this.collisionPolicy, MonoDirectionalTraversalDescription.addEvaluator(this.collisionEvaluator, collisionEvaluator), this.sideSelector, this.statementFactory, this.maxDepth);
    }

    public BidirectionalTraversalDescription collisionEvaluator(Evaluator collisionEvaluator) {
        return this.collisionEvaluator((PathEvaluator)new Evaluator.AsPathEvaluator(collisionEvaluator));
    }

    public BidirectionalTraversalDescription sideSelector(SideSelectorPolicy sideSelector, int maxDepth) {
        return new BidirectionalTraversalDescriptionImpl(this.start, this.end, this.collisionPolicy, this.collisionEvaluator, sideSelector, this.statementFactory, maxDepth);
    }

    public Traverser traverse(Node start, Node end) {
        return this.traverse(Arrays.asList(start), Arrays.asList(end));
    }

    public Traverser traverse(Iterable<Node> startNodes, Iterable<Node> endNodes) {
        return new DefaultTraverser((Factory<TraverserIterator>)((Factory)() -> {
            Resource resource = this.statementFactory.get();
            boolean success = false;
            try {
                BidirectionalTraverserIterator iterator = new BidirectionalTraverserIterator(resource, this.start, this.end, this.sideSelector, this.collisionPolicy, this.collisionEvaluator, this.maxDepth, startNodes, endNodes);
                success = true;
                BidirectionalTraverserIterator bidirectionalTraverserIterator = iterator;
                return bidirectionalTraverserIterator;
            }
            finally {
                if (!success) {
                    resource.close();
                }
            }
        }));
    }

    private void assertIsMonoDirectional(TraversalDescription traversal) {
        if (!(traversal instanceof MonoDirectionalTraversalDescription)) {
            throw new IllegalArgumentException("The bi-directional traversals currently do not support using anything but mono-directional traversers as start and stop points. Please provide a regular mono-directional traverser instead.");
        }
    }
}

