/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.impl.traversal.StartNodeTraversalBranch;

class AsOneStartBranch
implements TraversalBranch {
    private Iterator<TraversalBranch> branches;
    private int expanded;
    private final TraversalContext context;
    private final InitialBranchState initialState;
    private final UniquenessFactory uniqueness;

    AsOneStartBranch(TraversalContext context, Iterable<Node> nodes, InitialBranchState initialState, UniquenessFactory uniqueness) {
        this.context = context;
        this.initialState = initialState;
        this.uniqueness = uniqueness;
        this.branches = this.toBranches(nodes);
    }

    private Iterator<TraversalBranch> toBranches(Iterable<Node> nodes) {
        if (this.uniqueness.eagerStartBranches()) {
            ArrayList<StartNodeTraversalBranch> result = new ArrayList<StartNodeTraversalBranch>();
            for (Node node : nodes) {
                result.add(new StartNodeTraversalBranch(this.context, this, node, this.initialState));
            }
            return result.iterator();
        }
        return new TraversalBranchIterator(nodes.iterator());
    }

    public TraversalBranch parent() {
        return null;
    }

    public int length() {
        return -1;
    }

    public Node endNode() {
        throw new UnsupportedOperationException();
    }

    public Relationship lastRelationship() {
        throw new UnsupportedOperationException();
    }

    public TraversalBranch next(PathExpander expander, TraversalContext metadata) {
        if (this.branches.hasNext()) {
            ++this.expanded;
            return this.branches.next().next(expander, metadata);
        }
        return null;
    }

    public int expanded() {
        return this.expanded;
    }

    public boolean continues() {
        return true;
    }

    public boolean includes() {
        return false;
    }

    public void evaluation(Evaluation eval) {
        throw new UnsupportedOperationException();
    }

    public void initialize(PathExpander expander, TraversalContext metadata) {
    }

    public Node startNode() {
        throw new UnsupportedOperationException();
    }

    public Iterable<Relationship> relationships() {
        throw new UnsupportedOperationException();
    }

    public Iterable<Relationship> reverseRelationships() {
        throw new UnsupportedOperationException();
    }

    public Iterable<Node> nodes() {
        throw new UnsupportedOperationException();
    }

    public Iterable<Node> reverseNodes() {
        throw new UnsupportedOperationException();
    }

    public Iterator<PropertyContainer> iterator() {
        throw new UnsupportedOperationException();
    }

    public void prune() {
        this.branches = Collections.emptyList().iterator();
    }

    public Object state() {
        throw new UnsupportedOperationException();
    }

    private class TraversalBranchIterator
    implements Iterator<TraversalBranch> {
        private final Iterator<Node> nodeIterator;

        TraversalBranchIterator(Iterator<Node> nodeIterator) {
            this.nodeIterator = nodeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.nodeIterator.hasNext();
        }

        @Override
        public TraversalBranch next() {
            return new StartNodeTraversalBranch(AsOneStartBranch.this.context, AsOneStartBranch.this, this.nodeIterator.next(), AsOneStartBranch.this.initialState);
        }

        @Override
        public void remove() {
            this.nodeIterator.remove();
        }
    }
}

