/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

class FusionIndexReader
implements IndexReader {
    private final IndexReader nativeReader;
    private final IndexReader luceneReader;
    private final FusionSchemaIndexProvider.Selector selector;

    FusionIndexReader(IndexReader nativeReader, IndexReader luceneReader, FusionSchemaIndexProvider.Selector selector) {
        this.nativeReader = nativeReader;
        this.luceneReader = luceneReader;
        this.selector = selector;
    }

    public void close() {
        try {
            this.nativeReader.close();
        }
        finally {
            this.luceneReader.close();
        }
    }

    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        return this.selector.select(this.nativeReader, this.luceneReader, propertyValues).countIndexedNodes(nodeId, propertyValues);
    }

    @Override
    public IndexSampler createSampler() {
        return new FusionIndexSampler(this.nativeReader.createSampler(), this.luceneReader.createSampler());
    }

    @Override
    public PrimitiveLongIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            return this.luceneReader.query(predicates);
        }
        if (predicates[0] instanceof IndexQuery.ExactPredicate) {
            IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicates[0];
            return this.selector.select(this.nativeReader, this.luceneReader, exactPredicate.value()).query(predicates);
        }
        if (predicates[0] instanceof IndexQuery.NumberRangePredicate) {
            return this.nativeReader.query(predicates[0]);
        }
        if (predicates[0] instanceof IndexQuery.ExistsPredicate) {
            PrimitiveLongIterator nativeResult = this.nativeReader.query(predicates[0]);
            PrimitiveLongIterator luceneResult = this.luceneReader.query(predicates[0]);
            return PrimitiveLongCollections.concat((PrimitiveLongIterator[])new PrimitiveLongIterator[]{nativeResult, luceneResult});
        }
        return this.luceneReader.query(predicates);
    }

    @Override
    public boolean hasFullNumberPrecision(IndexQuery ... predicates) {
        if (predicates.length > 1) {
            return false;
        }
        IndexQuery predicate = predicates[0];
        if (predicate instanceof IndexQuery.ExactPredicate) {
            Value value = ((IndexQuery.ExactPredicate)predicate).value();
            return this.selector.select(this.nativeReader.hasFullNumberPrecision(predicates), this.luceneReader.hasFullNumberPrecision(predicates), value);
        }
        if (predicates[0] instanceof IndexQuery.NumberRangePredicate) {
            return this.nativeReader.hasFullNumberPrecision(predicates);
        }
        return false;
    }
}

