/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.PropertyConstraintDefinition;

abstract class MultiPropertyConstraintDefinition
extends PropertyConstraintDefinition {
    protected final String[] propertyKeys;

    protected MultiPropertyConstraintDefinition(InternalSchemaActions actions, String[] propertyKeys) {
        super(actions);
        this.propertyKeys = MultiPropertyConstraintDefinition.requireNonEmpty(propertyKeys);
    }

    protected MultiPropertyConstraintDefinition(InternalSchemaActions actions, IndexDefinition indexDefinition) {
        super(actions);
        this.propertyKeys = MultiPropertyConstraintDefinition.requireNonEmpty((String[])Iterables.asArray(String.class, (Iterable)indexDefinition.getPropertyKeys()));
    }

    private static String[] requireNonEmpty(String[] array) {
        Objects.requireNonNull(array);
        if (array.length < 1) {
            throw new IllegalArgumentException("Property constraint must have at least one property");
        }
        for (String field : array) {
            if (field != null) continue;
            throw new IllegalArgumentException("Property constraints cannot have null property names");
        }
        return array;
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        this.assertInUnterminatedTransaction();
        return Arrays.asList(this.propertyKeys);
    }
}

