/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Map;
import org.neo4j.kernel.impl.util.VersionedHashMap;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;

public class PropertyChanges {
    private VersionedHashMap<Integer, Map<Object, DiffSets<Long>>> changes;

    public ReadableDiffSets<Long> changesForProperty(int propertyKeyId, Object value) {
        DiffSets<Long> valueChanges;
        Map<Object, DiffSets<Long>> keyChanges;
        if (this.changes != null && (keyChanges = this.changes.get(propertyKeyId)) != null && (valueChanges = keyChanges.get(value)) != null) {
            return valueChanges;
        }
        return ReadableDiffSets.Empty.instance();
    }

    public void changeProperty(long entityId, int propertyKeyId, Object oldValue, Object newValue) {
        Map<Object, DiffSets<Long>> keyChanges = this.keyChanges(propertyKeyId);
        this.valueChanges(newValue, keyChanges).add((Object)entityId);
        this.valueChanges(oldValue, keyChanges).remove((Object)entityId);
    }

    public void addProperty(long entityId, int propertyKeyId, Object value) {
        this.valueChanges(value, this.keyChanges(propertyKeyId)).add((Object)entityId);
    }

    public void removeProperty(long entityId, int propertyKeyId, Object oldValue) {
        this.valueChanges(oldValue, this.keyChanges(propertyKeyId)).remove((Object)entityId);
    }

    private Map<Object, DiffSets<Long>> keyChanges(int propertyKeyId) {
        if (this.changes == null) {
            this.changes = new VersionedHashMap();
        }
        return this.changes.computeIfAbsent(propertyKeyId, k -> new VersionedHashMap());
    }

    private DiffSets<Long> valueChanges(Object newValue, Map<Object, DiffSets<Long>> keyChanges) {
        return keyChanges.computeIfAbsent(newValue, k -> new DiffSets());
    }
}

