/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import org.neo4j.configuration.Description;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Group;
import org.neo4j.kernel.configuration.GroupSettingSupport;
import org.neo4j.kernel.configuration.Settings;

@Group(value="dbms.connector")
public class Connector {
    @Description(value="Enable this connector")
    public final Setting<Boolean> enabled;
    @Description(value="Connector type. You should always set this to the connector type you want")
    public final Setting<ConnectorType> type;
    public final GroupSettingSupport group;

    @Deprecated
    public Connector(String key, String typeDefault) {
        this(key);
    }

    public Connector(String key) {
        this.group = new GroupSettingSupport(Connector.class, key);
        this.enabled = this.group.scope(Settings.setting("enabled", Settings.BOOLEAN, "false"));
        this.type = this.group.scope(Settings.setting("type", Settings.options(ConnectorType.class), Settings.NO_DEFAULT));
    }

    public String key() {
        return this.group.groupKey;
    }

    public static enum ConnectorType {
        BOLT,
        HTTP;

    }
}

