/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.summary.InternalNotification;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.internal.summary.InternalProfiledPlan;
import org.neo4j.driver.internal.summary.InternalResultSummary;
import org.neo4j.driver.internal.summary.InternalServerInfo;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.summary.StatementType;

public final class MetadataUtil {
    private MetadataUtil() {
    }

    public static List<String> extractStatementKeys(Map<String, Value> metadata) {
        Value keysValue = metadata.get("fields");
        if (keysValue != null && !keysValue.isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>(keysValue.size());
            for (Value value : keysValue.values()) {
                keys.add(value.asString());
            }
            return keys;
        }
        return Collections.emptyList();
    }

    public static long extractResultAvailableAfter(Map<String, Value> metadata) {
        Value resultAvailableAfterValue = metadata.get("result_available_after");
        if (resultAvailableAfterValue != null) {
            return resultAvailableAfterValue.asLong();
        }
        return -1L;
    }

    public static ResultSummary extractSummary(Statement statement, Connection connection, long resultAvailableAfter, Map<String, Value> metadata) {
        InternalServerInfo serverInfo = new InternalServerInfo(connection.serverAddress(), connection.serverVersion());
        return new InternalResultSummary(statement, serverInfo, MetadataUtil.extractStatementType(metadata), MetadataUtil.extractCounters(metadata), MetadataUtil.extractPlan(metadata), MetadataUtil.extractProfiledPlan(metadata), MetadataUtil.extractNotifications(metadata), resultAvailableAfter, MetadataUtil.extractResultConsumedAfter(metadata));
    }

    private static StatementType extractStatementType(Map<String, Value> metadata) {
        Value typeValue = metadata.get("type");
        if (typeValue != null) {
            return StatementType.fromCode(typeValue.asString());
        }
        return null;
    }

    private static InternalSummaryCounters extractCounters(Map<String, Value> metadata) {
        Value countersValue = metadata.get("stats");
        if (countersValue != null) {
            return new InternalSummaryCounters(MetadataUtil.counterValue(countersValue, "nodes-created"), MetadataUtil.counterValue(countersValue, "nodes-deleted"), MetadataUtil.counterValue(countersValue, "relationships-created"), MetadataUtil.counterValue(countersValue, "relationships-deleted"), MetadataUtil.counterValue(countersValue, "properties-set"), MetadataUtil.counterValue(countersValue, "labels-added"), MetadataUtil.counterValue(countersValue, "labels-removed"), MetadataUtil.counterValue(countersValue, "indexes-added"), MetadataUtil.counterValue(countersValue, "indexes-removed"), MetadataUtil.counterValue(countersValue, "constraints-added"), MetadataUtil.counterValue(countersValue, "constraints-removed"));
        }
        return null;
    }

    private static int counterValue(Value countersValue, String name) {
        Value value = countersValue.get(name);
        return value.isNull() ? 0 : value.asInt();
    }

    private static Plan extractPlan(Map<String, Value> metadata) {
        Value planValue = metadata.get("plan");
        if (planValue != null) {
            return InternalPlan.EXPLAIN_PLAN_FROM_VALUE.apply(planValue);
        }
        return null;
    }

    private static ProfiledPlan extractProfiledPlan(Map<String, Value> metadata) {
        Value profiledPlanValue = metadata.get("profile");
        if (profiledPlanValue != null) {
            return InternalProfiledPlan.PROFILED_PLAN_FROM_VALUE.apply(profiledPlanValue);
        }
        return null;
    }

    private static List<Notification> extractNotifications(Map<String, Value> metadata) {
        Value notificationsValue = metadata.get("notifications");
        if (notificationsValue != null) {
            return notificationsValue.asList(InternalNotification.VALUE_TO_NOTIFICATION);
        }
        return Collections.emptyList();
    }

    private static long extractResultConsumedAfter(Map<String, Value> metadata) {
        Value resultConsumedAfterValue = metadata.get("result_consumed_after");
        if (resultConsumedAfterValue != null) {
            return resultConsumedAfterValue.asLong();
        }
        return -1L;
    }
}

