/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.v1.Value;

public class ResetResponseHandler
implements ResponseHandler {
    private final InboundMessageDispatcher messageDispatcher;
    private final CompletableFuture<Void> completionFuture;

    public ResetResponseHandler(InboundMessageDispatcher messageDispatcher, CompletableFuture<Void> completionFuture) {
        this.messageDispatcher = messageDispatcher;
        this.completionFuture = completionFuture;
    }

    @Override
    public final void onSuccess(Map<String, Value> metadata) {
        this.resetCompleted();
    }

    @Override
    public final void onFailure(Throwable error) {
        this.resetCompleted();
    }

    @Override
    public final void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private void resetCompleted() {
        this.messageDispatcher.unMuteAckFailure();
        this.resetCompleted(this.completionFuture);
    }

    protected void resetCompleted(CompletableFuture<Void> completionFuture) {
        completionFuture.complete(null);
    }
}

