/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;

public final class BoltProtocolV1Util {
    public static final int HTTP = 1213486160;
    public static final int BOLT_MAGIC_PREAMBLE = 1616949271;
    public static final int PROTOCOL_VERSION_1 = 1;
    public static final int NO_PROTOCOL_VERSION = 0;
    public static final int CHUNK_HEADER_SIZE_BYTES = 2;
    public static final int DEFAULT_MAX_OUTBOUND_CHUNK_SIZE_BYTES = 16383;
    private static final ByteBuf BOLT_V1_HANDSHAKE_BUF = Unpooled.unreleasableBuffer(Unpooled.copyInt(1616949271, 1, 0, 0, 0)).asReadOnly();

    private BoltProtocolV1Util() {
    }

    public static ByteBuf handshakeBuf() {
        return BOLT_V1_HANDSHAKE_BUF.duplicate();
    }

    public static String handshakeString() {
        return "[0x6060B017, 1, 0, 0, 0]";
    }

    public static void writeMessageBoundary(ByteBuf buf) {
        buf.writeShort(0);
    }

    public static void writeEmptyChunkHeader(ByteBuf buf) {
        buf.writeShort(0);
    }

    public static void writeChunkHeader(ByteBuf buf, int chunkStartIndex, int headerValue) {
        buf.setShort(chunkStartIndex, headerValue);
    }
}

