/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.internal.builder.LucenePropertyHelper;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;

public class LuceneQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<Query, LuceneQueryParsingResult> {
    private final LucenePropertyHelper propertyHelper;
    private List<SortField> sortFields;

    public LuceneQueryRendererDelegate(EntityNamesResolver entityNames, SingleEntityQueryBuilder<Query> builder, Map<String, Object> namedParameters, LucenePropertyHelper propertyHelper) {
        super((PropertyHelper)propertyHelper, entityNames, builder, namedParameters);
        this.propertyHelper = propertyHelper;
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(5);
        }
        SortField.Type sortType = this.sortType(propertyPath);
        this.sortFields.add(new SortField(propertyPath.asStringPathWithoutAlias(), sortType, !isAscending));
    }

    private SortField.Type sortType(PropertyPath propertyPath) {
        NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = this.propertyHelper.getNumericEncodingType(this.targetTypeName, propertyPath.getNodeNamesWithoutAlias());
        if (numericEncodingType != null) {
            switch (numericEncodingType) {
                case INTEGER: {
                    return SortField.Type.INT;
                }
                case LONG: {
                    return SortField.Type.LONG;
                }
                case FLOAT: {
                    return SortField.Type.FLOAT;
                }
                case DOUBLE: {
                    return SortField.Type.DOUBLE;
                }
            }
            return SortField.Type.STRING;
        }
        return SortField.Type.STRING;
    }

    public LuceneQueryParsingResult getResult() {
        Sort sort = null;
        if (this.sortFields != null) {
            sort = new Sort(this.sortFields.toArray(new SortField[this.sortFields.size()]));
        }
        return new LuceneQueryParsingResult((Query)this.builder.build(), this.targetTypeName, this.targetType, this.projections, sort);
    }

    public void setPropertyPath(PropertyPath propertyPath) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            if (propertyPath.getNodes().size() == 1 && ((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).isAlias()) {
                this.projections.add("__HSearch_This");
            } else {
                List names = this.resolveAlias(propertyPath);
                this.projections.add(this.join(names));
            }
        } else {
            this.propertyPath = propertyPath;
        }
    }

    private String join(List<String> names) {
        StringBuilder projection = new StringBuilder();
        for (String name : names) {
            projection.append('.');
            projection.append(name);
        }
        return projection.substring(1);
    }
}

