/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jEntityQueries;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.NodeWithEmbeddedNodes;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Graph;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;

public final class HttpNeo4jAssociatedNodesHelper {
    private HttpNeo4jAssociatedNodesHelper() {
    }

    public static Map<String, Graph.Node> findAssociatedNodes(HttpNeo4jClient client, Long txId, NodeWithEmbeddedNodes node, EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext, HttpNeo4jEntityQueries queries) {
        HashMap<String, Graph.Node> associatedNodes = new HashMap<String, Graph.Node>(tupleTypeContext.getAllAssociatedEntityKeyMetadata().size());
        if (tupleTypeContext.getAllAssociatedEntityKeyMetadata().size() > 0) {
            Object[] keyValues = HttpNeo4jAssociatedNodesHelper.keyValues(node.getOwner(), entityKeyMetadata);
            for (Map.Entry entry : tupleTypeContext.getAllAssociatedEntityKeyMetadata().entrySet()) {
                String associationRole = (String)tupleTypeContext.getAllRoles().get(entry.getKey());
                Graph.Node associatedEntity = queries.findAssociatedEntity(client, txId, keyValues, associationRole);
                associatedNodes.put(associationRole, associatedEntity);
            }
        }
        return associatedNodes;
    }

    private static Object[] keyValues(Graph.Node node, EntityKeyMetadata entityKeyMetadata) {
        Object[] values = new Object[entityKeyMetadata.getColumnNames().length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = node.getProperties().get(entityKeyMetadata.getColumnNames()[i]);
        }
        return values;
    }
}

