/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public final class GraphLogger {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    private GraphLogger() {
    }

    public static void log(Node node) {
        GraphLogger.log("%1$s", node);
    }

    public static void log(Relationship relationship) {
        GraphLogger.log("%1$s", relationship);
    }

    public static void log(String msg, Node node) {
        if (log.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder();
            GraphLogger.nodeAsCypher(builder, node);
            log.tracef(msg, builder.toString());
        }
    }

    public static void log(String msg, Relationship relationship) {
        if (log.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder();
            if (relationship != null) {
                GraphLogger.nodeAsCypher(builder, relationship.getStartNode());
                builder.append(" - [");
                CypherDSL.identifier(builder, relationship.getType().name());
                GraphLogger.appendProperties(builder, (PropertyContainer)relationship);
                builder.append("] - ");
                GraphLogger.nodeAsCypher(builder, relationship.getEndNode());
            } else {
                builder.append("null");
            }
            log.tracef(msg, builder.toString());
        }
    }

    private static void nodeAsCypher(StringBuilder builder, Node node) {
        if (node != null) {
            builder.append("(");
            for (Label label : node.getLabels()) {
                builder.append(":");
                CypherDSL.identifier(builder, label.name());
            }
            GraphLogger.appendProperties(builder, (PropertyContainer)node);
            builder.append(")");
        } else {
            builder.append("null");
        }
    }

    private static void appendProperties(StringBuilder builder, PropertyContainer propertyContainer) {
        String property;
        Iterator propertyKeys = propertyContainer.getPropertyKeys().iterator();
        boolean hasProperties = false;
        if (propertyKeys.hasNext()) {
            hasProperties = true;
            builder.append("{");
            property = (String)propertyKeys.next();
            CypherDSL.identifier(builder, property);
            builder.append(":");
            CypherDSL.literal(builder, propertyContainer.getProperty(property));
        }
        while (propertyKeys.hasNext()) {
            builder.append(", ");
            property = (String)propertyKeys.next();
            CypherDSL.identifier(builder, property);
            builder.append(":");
            CypherDSL.literal(builder, propertyContainer.getProperty(property));
        }
        if (hasProperties) {
            builder.append("}");
        }
    }
}

