/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.strong;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.util.ByteString;

public class StrongCounterKey
implements CounterKey {
    public static final AdvancedExternalizer<StrongCounterKey> EXTERNALIZER = new Externalizer();
    private final ByteString counterName;

    StrongCounterKey(String counterName) {
        this(ByteString.fromString((String)counterName));
    }

    private StrongCounterKey(ByteString counterName) {
        this.counterName = Objects.requireNonNull(counterName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrongCounterKey that = (StrongCounterKey)o;
        return this.counterName.equals((Object)that.counterName);
    }

    public int hashCode() {
        return this.counterName.hashCode();
    }

    public String toString() {
        return "CounterKey{counterName=" + this.counterName + '}';
    }

    @Override
    public ByteString getCounterName() {
        return this.counterName;
    }

    private static class Externalizer
    implements AdvancedExternalizer<StrongCounterKey> {
        private Externalizer() {
        }

        public Set<Class<? extends StrongCounterKey>> getTypeClasses() {
            return Collections.singleton(StrongCounterKey.class);
        }

        public Integer getId() {
            return ExternalizerIds.STRONG_COUNTER_KEY;
        }

        public void writeObject(ObjectOutput output, StrongCounterKey object) throws IOException {
            ByteString.writeObject((ObjectOutput)output, (ByteString)object.counterName);
        }

        public StrongCounterKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new StrongCounterKey(ByteString.readObject((ObjectInput)input));
        }
    }
}

