/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.strong;

import java.util.concurrent.CompletionException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.strong.AbstractStrongCounter;
import org.infinispan.counter.impl.strong.StrongCounterKey;
import org.infinispan.counter.logging.Log;

public class BoundedStrongCounter
extends AbstractStrongCounter {
    private static final Log log = (Log)LogFactory.getLog(BoundedStrongCounter.class, Log.class);

    public BoundedStrongCounter(String counterName, AdvancedCache<StrongCounterKey, CounterValue> cache, CounterConfiguration configuration) {
        super(counterName, cache, configuration);
    }

    @Override
    protected long handleAddResult(CounterValue counterValue) {
        if (counterValue == null) {
            throw new CompletionException((Throwable)log.counterDeleted());
        }
        this.throwOutOfBoundExceptionIfNeeded(counterValue.getState());
        return counterValue.getValue();
    }

    @Override
    protected Boolean handleCASResult(CounterState state) {
        if (state == null) {
            return false;
        }
        this.throwOutOfBoundExceptionIfNeeded(state);
        return state == CounterState.VALID;
    }

    private void throwOutOfBoundExceptionIfNeeded(CounterState state) {
        switch (state) {
            case LOWER_BOUND_REACHED: {
                throw new CompletionException((Throwable)log.counterOurOfBounds("Lower bound"));
            }
            case UPPER_BOUND_REACHED: {
                throw new CompletionException((Throwable)log.counterOurOfBounds("Upper bound"));
            }
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    public String toString() {
        return "BoundedStrongCounter{counterName=" + this.key.getCounterName() + '}';
    }
}

