/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.interceptor;

import java.util.Collection;
import java.util.EnumSet;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.logging.Log;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;

public class CounterConfigurationInterceptor
extends BaseCustomAsyncInterceptor {
    private static final Log log = (Log)LogFactory.getLog(CounterConfigurationInterceptor.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final Collection<Flag> FLAGS_TO_SKIP_PERSISTENCE = EnumSet.of(Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE);

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        CounterConfiguration value;
        CacheEntry entry = ctx.lookupEntry(command.getKey());
        CounterConfiguration counterConfiguration = value = entry == null ? null : (CounterConfiguration)entry.getValue();
        if (value != null && value.storage() == Storage.VOLATILE) {
            if (trace) {
                log.tracef("Setting skip persistence for %s", command.getKey());
            }
            command.setFlagsBitSet(EnumUtil.setEnums((long)command.getFlagsBitSet(), FLAGS_TO_SKIP_PERSISTENCE));
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }
}

