/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.io.Serializable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.impl.AssociationContextImpl;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.entityentry.impl.OgmEntityEntryState;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.impl.EntityKeyBuilder;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.LogicalPhysicalConverterHelper;
import org.hibernate.ogm.util.impl.TransactionContextHelper;
import org.hibernate.persister.entity.EntityPersister;

public class AssociationPersister {
    private GridType keyGridType;
    private Object key;
    private SharedSessionContractImplementor session;
    private AssociationKey associationKey;
    private Association association;
    private Object[] columnValues;
    private GridDialect gridDialect;
    private AssociationContext associationContext;
    private AssociationTypeContext associationTypeContext;
    private AssociationKeyMetadata associationKeyMetadata;
    private final Class<?> hostingEntityType;
    private Object hostingEntity;
    private Boolean hostingEntityRequiresReadAfterUpdate;
    private EntityPersister hostingEntityPersister;

    private AssociationPersister(Builder builder) {
        this.hostingEntityType = builder.targetEntityType;
        this.hostingEntity = builder.hostingEntity;
        this.gridDialect = builder.gridDialect;
        this.session = builder.session;
        this.key = builder.key;
        this.keyGridType = builder.keyGridType;
        this.associationTypeContext = builder.associationTypeContext;
        this.associationKeyMetadata = builder.associationKeyMetadata;
        this.columnValues = builder.keyColumnValues;
    }

    public AssociationKey getAssociationKey() {
        if (this.associationKey == null) {
            Object[] columnValues = this.getKeyColumnValues();
            EntityKey ownerEntityKey = this.key != null ? EntityKeyBuilder.fromPersister(this.getHostingEntityPersister(), (Serializable)this.key, this.session) : new EntityKey(this.getHostingEntityPersister().getEntityKeyMetadata(), columnValues);
            this.associationKey = new AssociationKey(this.associationKeyMetadata, columnValues, ownerEntityKey);
        }
        return this.associationKey;
    }

    private Object[] getKeyColumnValues() {
        if (this.columnValues == null) {
            this.columnValues = LogicalPhysicalConverterHelper.getColumnsValuesFromObjectValue(this.key, this.keyGridType, this.associationKeyMetadata.getColumnNames(), this.session);
        }
        return this.columnValues;
    }

    public Association getAssociation() {
        if (this.association == null) {
            AssociationKey key = this.getAssociationKey();
            if (this.hostingEntity != null) {
                OgmEntityEntryState entryState = OgmEntityEntryState.getStateFor(this.session, this.hostingEntity);
                if (entryState.hasAssociation(this.associationKeyMetadata.getCollectionRole())) {
                    this.association = entryState.getAssociation(this.associationKeyMetadata.getCollectionRole());
                } else {
                    this.association = this.gridDialect.getAssociation(key, this.getAssociationContext());
                    OgmEntityEntryState.getStateFor(this.session, this.hostingEntity).setAssociation(this.associationKeyMetadata.getCollectionRole(), this.association);
                }
            } else {
                this.association = this.gridDialect.getAssociation(key, this.getAssociationContext());
            }
            if (this.association == null) {
                this.association = this.gridDialect.createAssociation(key, this.getAssociationContext());
                if (this.hostingEntity != null) {
                    OgmEntityEntryState.getStateFor(this.session, this.hostingEntity).setAssociation(this.associationKeyMetadata.getCollectionRole(), this.association);
                }
            }
        }
        return this.association;
    }

    public Association getAssociationOrNull() {
        if (this.association == null) {
            OgmEntityEntryState entryState;
            if (this.hostingEntity != null && (entryState = OgmEntityEntryState.getStateFor(this.session, this.hostingEntity)).hasAssociation(this.associationKeyMetadata.getCollectionRole())) {
                this.association = entryState.getAssociation(this.associationKeyMetadata.getCollectionRole());
                return this.association;
            }
            if (this.association == null) {
                this.association = this.gridDialect.getAssociation(this.getAssociationKey(), this.getAssociationContext());
                if (this.hostingEntity != null) {
                    OgmEntityEntryState.getStateFor(this.session, this.hostingEntity).setAssociation(this.associationKeyMetadata.getCollectionRole(), this.association);
                }
            }
        }
        return this.association;
    }

    public void flushToDatastore() {
        if (this.getAssociation().isEmpty()) {
            this.gridDialect.removeAssociation(this.getAssociationKey(), this.getAssociationContext());
            this.association = null;
            OgmEntityEntryState.getStateFor(this.session, this.hostingEntity).setAssociation(this.associationKeyMetadata.getCollectionRole(), null);
        } else if (!this.getAssociation().getOperations().isEmpty()) {
            this.gridDialect.insertOrUpdateAssociation(this.getAssociationKey(), this.getAssociation(), this.getAssociationContext());
        }
        this.updateHostingEntityIfRequired();
    }

    private void updateHostingEntityIfRequired() {
        if (this.hostingEntity != null && this.hostingEntityRequiresReadAfterUpdate()) {
            OgmEntityPersister entityPersister = this.getHostingEntityPersister();
            if (GridDialects.hasFacet(this.gridDialect, GroupingByEntityDialect.class)) {
                ((GroupingByEntityDialect)this.gridDialect).flushPendingOperations(this.getAssociationKey().getEntityKey(), entityPersister.getTupleContext(this.session));
            }
            entityPersister.processUpdateGeneratedProperties(entityPersister.getIdentifier(this.hostingEntity, this.session), this.hostingEntity, new Object[entityPersister.getPropertyNames().length], this.session);
        }
    }

    public boolean hostingEntityRequiresReadAfterUpdate() {
        if (this.hostingEntityRequiresReadAfterUpdate == null) {
            boolean storedInEntityStructure = this.gridDialect.isStoredInEntityStructure(this.associationKeyMetadata, this.associationTypeContext);
            boolean hasUpdateGeneratedProperties = this.getHostingEntityPersister().hasUpdateGeneratedProperties();
            this.hostingEntityRequiresReadAfterUpdate = storedInEntityStructure && hasUpdateGeneratedProperties;
        }
        return this.hostingEntityRequiresReadAfterUpdate;
    }

    private OgmEntityPersister getHostingEntityPersister() {
        if (this.hostingEntityPersister == null) {
            this.hostingEntityPersister = this.session.getFactory().getMetamodel().entityPersister(this.hostingEntityType);
        }
        return (OgmEntityPersister)this.hostingEntityPersister;
    }

    public AssociationContext getAssociationContext() {
        if (this.associationContext == null) {
            this.associationContext = new AssociationContextImpl(this.associationTypeContext, this.hostingEntity != null ? OgmEntityEntryState.getStateFor(this.session, this.hostingEntity).getTuplePointer() : new TuplePointer(), TransactionContextHelper.transactionContext(this.session));
        }
        return this.associationContext;
    }

    public static class Builder {
        public Class<?> targetEntityType;
        public AssociationKeyMetadata associationKeyMetadata;
        public AssociationTypeContext associationTypeContext;
        public GridType keyGridType;
        public Object key;
        public SharedSessionContractImplementor session;
        public GridDialect gridDialect;
        public Object hostingEntity;
        private Object[] keyColumnValues;

        public Builder(Class<?> targetEntityType) {
            this.targetEntityType = targetEntityType;
        }

        public Builder gridDialect(GridDialect gridDialect) {
            this.gridDialect = gridDialect;
            return this;
        }

        public Builder session(SharedSessionContractImplementor session) {
            this.session = session;
            return this;
        }

        public Builder key(Object key, GridType keyGridType) {
            this.key = key;
            this.keyGridType = keyGridType;
            return this;
        }

        public Builder keyColumnValues(Object[] columnValues) {
            this.keyColumnValues = columnValues;
            return this;
        }

        public Builder hostingEntity(Object hostingEntity) {
            this.hostingEntity = hostingEntity;
            return this;
        }

        public Builder associationTypeContext(AssociationTypeContext associationTypeContext) {
            this.associationTypeContext = associationTypeContext;
            return this;
        }

        public Builder associationKeyMetadata(AssociationKeyMetadata associationKeyMetadata) {
            this.associationKeyMetadata = associationKeyMetadata;
            return this;
        }

        public AssociationPersister build() {
            return new AssociationPersister(this);
        }
    }
}

