/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.impl;

import org.hibernate.HibernateException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.ogm.type.impl.GridTypeDelegatingToCoreType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public abstract class EntityType
extends GridTypeDelegatingToCoreType {
    protected final TypeTranslator typeTranslator;
    protected final org.hibernate.type.EntityType delegate;

    public EntityType(org.hibernate.type.EntityType type, TypeTranslator typeTranslator) {
        super((Type)type);
        this.delegate = type;
        this.typeTranslator = typeTranslator;
    }

    @Override
    public Object convertToBackendType(Object value, SessionFactoryImplementor sessionFactory) {
        return this.getIdentifier(value, sessionFactory);
    }

    protected final Object getIdentifier(Object value, SharedSessionContractImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        boolean isNotEmbedded = this.isNotEmbedded(session);
        if (isNotEmbedded) {
            return value;
        }
        String associatedEntityName = this.delegate.getAssociatedEntityName();
        String uniqueKeyPropertyName = this.delegate.getRHSUniqueKeyPropertyName();
        if (StringHelper.isEmpty(uniqueKeyPropertyName)) {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved((String)associatedEntityName, (Object)value, (SharedSessionContractImplementor)session);
        }
        EntityPersister persister = session.getFactory().getMetamodel().entityPersister(this.delegate.getAssociatedEntityName());
        Object propertyValue = persister.getPropertyValue(value, uniqueKeyPropertyName);
        Type type = persister.getPropertyType(uniqueKeyPropertyName);
        GridType gridType = this.typeTranslator.getType(type);
        if (gridType.isEntityType()) {
            propertyValue = ((EntityType)gridType).getIdentifier(propertyValue, session);
        }
        return propertyValue;
    }

    protected final Object getIdentifier(Object value, SessionFactoryImplementor sessionFactory) throws HibernateException {
        if (value == null) {
            return null;
        }
        EntityPersister persister = sessionFactory.getMetamodel().entityPersister(this.delegate.getAssociatedEntityName());
        String uniqueKeyPropertyName = this.delegate.getRHSUniqueKeyPropertyName();
        if (StringHelper.isEmpty(uniqueKeyPropertyName)) {
            return persister.getIdentifier(value, null);
        }
        Object propertyValue = persister.getPropertyValue(value, uniqueKeyPropertyName);
        Type type = persister.getPropertyType(uniqueKeyPropertyName);
        GridType gridType = this.typeTranslator.getType(type);
        if (gridType.isEntityType()) {
            propertyValue = this.getIdentifier(propertyValue, sessionFactory);
        }
        return propertyValue;
    }

    protected boolean isNotEmbedded(SharedSessionContractImplementor session) {
        return false;
    }
}

