/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;

public class SessionFactoryEntityNamesResolver
implements EntityNamesResolver {
    private final SessionFactoryImplementor sessionFactory;
    private final ClassLoaderService classLoaderService;

    public SessionFactoryEntityNamesResolver(SessionFactory sessionFactory) {
        this.sessionFactory = (SessionFactoryImplementor)sessionFactory;
        this.classLoaderService = (ClassLoaderService)this.sessionFactory.getServiceRegistry().getService(ClassLoaderService.class);
    }

    public Class<?> getClassFromName(String entityName) {
        return this.classLoaderService.classForName(this.sessionFactory.getMetamodel().getImportedClassName(entityName));
    }
}

