/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.massindex.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.massindex.impl.OptionallyWrapInJTATransaction;
import org.hibernate.ogm.massindex.impl.TupleIndexer;
import org.hibernate.ogm.model.impl.DefaultEntityKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.util.logging.impl.Log;

public class BatchIndexingWorkspace
implements Runnable {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ExtendedSearchIntegrator searchIntegrator;
    private final SessionFactoryImplementor sessionFactory;
    private final IndexedTypeIdentifier indexedTypeIdentifier;
    private final MassIndexerProgressMonitor monitor;
    private final CacheMode cacheMode;
    private final BatchBackend batchBackend;
    private final GridDialect gridDialect;
    private final CountDownLatch endAllSignal;
    private final String tenantId;

    public BatchIndexingWorkspace(GridDialect gridDialect, SearchIntegrator search, SessionFactoryImplementor sessionFactory, IndexedTypeIdentifier indexedTypeIdentifier, CacheMode cacheMode, CountDownLatch endAllSignal, MassIndexerProgressMonitor monitor, BatchBackend backend, String tenantId) {
        this.gridDialect = gridDialect;
        this.indexedTypeIdentifier = indexedTypeIdentifier;
        this.tenantId = tenantId;
        this.searchIntegrator = (ExtendedSearchIntegrator)search.unwrap(ExtendedSearchIntegrator.class);
        this.sessionFactory = sessionFactory;
        this.cacheMode = cacheMode;
        this.endAllSignal = endAllSignal;
        this.batchBackend = backend;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ErrorHandler errorHandler = this.searchIntegrator.getErrorHandler();
        try {
            OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getMetamodel().entityPersister(this.indexedTypeIdentifier.getPojoType());
            DefaultEntityKeyMetadata keyMetadata = new DefaultEntityKeyMetadata(persister.getTableName(), persister.getRootTableIdentifierColumnNames());
            TupleIndexer consumer = new TupleIndexer(this.indexedTypeIdentifier, this.monitor, this.sessionFactory, this.searchIntegrator, this.cacheMode, this.batchBackend, errorHandler, this.tenantId);
            this.gridDialect.forEachTuple(new OptionallyWrapInJTATransaction((SessionFactory)this.sessionFactory, errorHandler, consumer), persister.getTupleTypeContext(), keyMetadata);
        }
        catch (RuntimeException re) {
            errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), (Throwable)re);
        }
        finally {
            this.endAllSignal.countDown();
        }
    }
}

