/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.loader.entity.impl;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.Loader;
import org.hibernate.loader.entity.EntityJoinWalker;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.ogm.loader.entity.impl.BatchableEntityLoader;
import org.hibernate.ogm.loader.entity.impl.BatchingEntityLoader;
import org.hibernate.ogm.loader.entity.impl.BatchingEntityLoaderBuilder;
import org.hibernate.ogm.loader.impl.OgmLoadingContext;
import org.hibernate.ogm.loader.impl.TupleBasedEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

class DynamicBatchingEntityLoaderBuilder
extends BatchingEntityLoaderBuilder {
    public static final DynamicBatchingEntityLoaderBuilder INSTANCE = new DynamicBatchingEntityLoaderBuilder();
    private static final Logger log = Logger.getLogger(DynamicBatchingEntityLoaderBuilder.class);

    DynamicBatchingEntityLoaderBuilder() {
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers, BatchingEntityLoaderBuilder.BatchableEntityLoaderBuilder innerEntityLoaderBuilder) {
        return new DynamicBatchingEntityLoader(persister, batchSize, lockMode, factory, influencers, innerEntityLoaderBuilder);
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers, BatchingEntityLoaderBuilder.BatchableEntityLoaderBuilder innerEntityLoaderBuilder) {
        return new DynamicBatchingEntityLoader(persister, batchSize, lockOptions, factory, influencers, innerEntityLoaderBuilder);
    }

    public static class DynamicEntityLoader
    extends EntityLoader {
        private final String sqlTemplate;
        private final String alias;

        public DynamicEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            this(persister, maxBatchSize, lockOptions.getLockMode(), factory, loadQueryInfluencers);
        }

        public DynamicEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister, -1, lockMode, factory, loadQueryInfluencers);
            EntityJoinWalker walker = new EntityJoinWalker(persister, persister.getIdentifierColumnNames(), -1, lockMode, factory, loadQueryInfluencers){

                protected StringBuilder whereString(String alias, String[] columnNames, int batchSize) {
                    return StringHelper.buildBatchFetchRestrictionFragment((String)alias, (String[])columnNames, (Dialect)this.getFactory().getDialect());
                }
            };
            this.initFromWalker((JoinWalker)walker);
            this.sqlTemplate = walker.getSQLString();
            this.alias = walker.getAlias();
            this.postInstantiate();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("SQL-template for dynamic entity [%s] batch-fetching [%s] : %s", (Object)this.entityName, (Object)lockMode, (Object)this.sqlTemplate);
            }
        }

        protected boolean isSingleRowLoader() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List doEntityBatchFetch(SessionImplementor session, QueryParameters queryParameters, Serializable[] ids) {
            List list;
            String sql = StringHelper.expandBatchIdPlaceholder((String)this.sqlTemplate, (Serializable[])ids, (String)this.alias, (String[])this.persister.getKeyColumnNames(), (Dialect)this.getFactory().getDialect());
            PersistenceContext persistenceContext = session.getPersistenceContext();
            boolean defaultReadOnlyOrig = persistenceContext.isDefaultReadOnly();
            if (queryParameters.isReadOnlyInitialized()) {
                persistenceContext.setDefaultReadOnly(queryParameters.isReadOnly());
            } else {
                queryParameters.setReadOnly(persistenceContext.isDefaultReadOnly());
            }
            persistenceContext.beforeLoad();
            try {
                List results;
                try {
                    results = this.doTheLoad(sql, queryParameters, session);
                }
                finally {
                    persistenceContext.afterLoad();
                }
                persistenceContext.initializeNonLazyCollections();
                log.debug((Object)"Done batch load");
                list = results;
            }
            catch (Throwable throwable) {
                try {
                    persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
                    throw throwable;
                }
                catch (SQLException sqle) {
                    throw ((JdbcServices)session.getFactory().getServiceRegistry().getService(JdbcServices.class)).getSqlExceptionHelper().convert(sqle, "could not load an entity batch: " + MessageHelper.infoString((EntityPersister)this.getEntityPersisters()[0], (Serializable[])ids, (SessionFactoryImplementor)session.getFactory()), sql);
                }
            }
            persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List doTheLoad(String sql, QueryParameters queryParameters, SessionImplementor session) throws SQLException {
            RowSelection selection = queryParameters.getRowSelection();
            int maxRows = LimitHelper.hasMaxRows((RowSelection)selection) ? selection.getMaxRows() : Integer.MAX_VALUE;
            ArrayList afterLoadActions = new ArrayList();
            Loader.SqlStatementWrapper wrapper = this.executeQueryStatement(sql, queryParameters, false, afterLoadActions, (SharedSessionContractImplementor)session);
            ResultSet rs = wrapper.getResultSet();
            Statement st = wrapper.getStatement();
            try {
                List list = this.processResultSet(rs, queryParameters, (SharedSessionContractImplementor)session, false, null, maxRows, afterLoadActions);
                return list;
            }
            finally {
                session.getJdbcCoordinator().getResourceRegistry().release(st);
                session.getJdbcCoordinator().afterStatementExecution();
            }
        }
    }

    public static class DynamicBatchingEntityLoader
    extends BatchingEntityLoader
    implements TupleBasedEntityLoader {
        private final int maxBatchSize;
        private final TupleBasedEntityLoader singleKeyLoader;
        private final BatchableEntityLoader dynamicLoader;

        public DynamicBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers, BatchingEntityLoaderBuilder.BatchableEntityLoaderBuilder innerEntityLoaderBuilder) {
            super((EntityPersister)persister);
            this.maxBatchSize = maxBatchSize;
            this.singleKeyLoader = (TupleBasedEntityLoader)innerEntityLoaderBuilder.buildLoader(persister, 1, lockMode, factory, loadQueryInfluencers);
            this.dynamicLoader = innerEntityLoaderBuilder.buildDynamicLoader(persister, maxBatchSize, lockMode, factory, loadQueryInfluencers);
        }

        public DynamicBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers, BatchingEntityLoaderBuilder.BatchableEntityLoaderBuilder innerEntityLoaderBuilder) {
            super((EntityPersister)persister);
            this.maxBatchSize = maxBatchSize;
            this.singleKeyLoader = (TupleBasedEntityLoader)innerEntityLoaderBuilder.buildLoader(persister, 1, lockOptions, factory, loadQueryInfluencers);
            this.dynamicLoader = innerEntityLoaderBuilder.buildDynamicLoader(persister, maxBatchSize, lockOptions, factory, loadQueryInfluencers);
        }

        public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions) {
            Serializable[] batch = session.getPersistenceContext().getBatchFetchQueue().getEntityBatch(this.persister(), id, this.maxBatchSize, this.persister().getEntityMode());
            int numberOfIds = ArrayHelper.countNonNull((Serializable[])batch);
            if (numberOfIds <= 1) {
                return this.singleKeyLoader.load(id, optionalObject, session);
            }
            Serializable[] idsToLoad = new Serializable[numberOfIds];
            System.arraycopy(batch, 0, idsToLoad, 0, numberOfIds);
            return this.doBatchLoad(id, this.dynamicLoader, session, idsToLoad, optionalObject, lockOptions);
        }

        @Override
        public List<Object> loadEntitiesFromTuples(SharedSessionContractImplementor session, LockOptions lockOptions, OgmLoadingContext ogmContext) {
            return this.singleKeyLoader.loadEntitiesFromTuples(session, lockOptions, ogmContext);
        }
    }
}

