/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;

public class AssociationTypeContextImpl
implements AssociationTypeContext {
    private final OptionsContext optionsContext;
    private final OptionsContext hostingEntityOptionsContext;
    private final TupleTypeContext hostingEntityTupleTypeContext;
    private final AssociatedEntityKeyMetadata associatedEntityKeyMetadata;
    private final String roleOnMainSide;

    private AssociationTypeContextImpl(OptionsContext optionsContext, OptionsContext hostingEntityOptionsContext, TupleTypeContext hostingEntityTupleTypeContext, AssociatedEntityKeyMetadata associatedEntityKeyMetadata, String roleOnMainSide) {
        this.optionsContext = optionsContext;
        this.hostingEntityOptionsContext = hostingEntityOptionsContext;
        this.hostingEntityTupleTypeContext = hostingEntityTupleTypeContext;
        this.associatedEntityKeyMetadata = associatedEntityKeyMetadata;
        this.roleOnMainSide = roleOnMainSide;
    }

    @Override
    public OptionsContext getOptionsContext() {
        return this.optionsContext;
    }

    @Override
    public OptionsContext getHostingEntityOptionsContext() {
        return this.hostingEntityOptionsContext;
    }

    @Override
    public TupleTypeContext getHostingEntityTupleTypeContext() {
        return this.hostingEntityTupleTypeContext;
    }

    @Override
    public AssociatedEntityKeyMetadata getAssociatedEntityKeyMetadata() {
        return this.associatedEntityKeyMetadata;
    }

    @Override
    public String getRoleOnMainSide() {
        return this.roleOnMainSide;
    }

    public String toString() {
        return "AssociationContext [optionsContext=" + this.optionsContext + "]";
    }

    public static class Builder {
        private AssociationKeyMetadata associationKeyMetadata;
        private OptionsService.OptionsServiceContext serviceContext;
        private OgmEntityPersister hostingEntityPersister;
        private String mainSidePropertyName;

        public Builder(OptionsService.OptionsServiceContext optionsServiceContext) {
            this.serviceContext = optionsServiceContext;
        }

        public Builder hostingEntityPersister(OgmEntityPersister ownerEntityPersister) {
            this.hostingEntityPersister = ownerEntityPersister;
            return this;
        }

        public Builder mainSidePropertyName(String mainSidePropertyName) {
            this.mainSidePropertyName = mainSidePropertyName;
            return this;
        }

        public Builder associationKeyMetadata(AssociationKeyMetadata associationKeyMetadata) {
            this.associationKeyMetadata = associationKeyMetadata;
            return this;
        }

        public AssociationTypeContextImpl build() {
            OptionsContext hostingPropertyOptions = this.serviceContext.getPropertyOptions(this.hostingEntityPersister.getMappedClass(), this.associationKeyMetadata.getCollectionRole());
            OptionsContext hostingEntityOptions = this.serviceContext.getEntityOptions(this.hostingEntityPersister.getEntityType().getReturnedClass());
            TupleTypeContext tupleTypeContext = this.hostingEntityPersister.getTupleTypeContext();
            return new AssociationTypeContextImpl(hostingPropertyOptions, hostingEntityOptions, tupleTypeContext, this.associationKeyMetadata.getAssociatedEntityKeyMetadata(), this.mainSidePropertyName);
        }
    }
}

