/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.eventstate.impl;

import org.hibernate.HibernateException;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManager;

public class EventContextManagingAutoFlushEventListener
implements AutoFlushEventListener {
    private AutoFlushEventListener delegate;
    private final EventContextManager stateManager;

    public EventContextManagingAutoFlushEventListener(EventContextManager stateManager) {
        this.stateManager = stateManager;
    }

    public void setDelegate(AutoFlushEventListener delegate) {
        this.delegate = delegate;
    }

    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        this.stateManager.onEventBegin(event.getSession());
        try {
            this.delegate.onAutoFlush(event);
        }
        finally {
            this.stateManager.onEventFinished();
        }
    }

    public static class EventContextManagingAutoFlushEventListenerDuplicationStrategy
    implements DuplicationStrategy {
        public static final DuplicationStrategy INSTANCE = new EventContextManagingAutoFlushEventListenerDuplicationStrategy();

        private EventContextManagingAutoFlushEventListenerDuplicationStrategy() {
        }

        public boolean areMatch(Object listener, Object original) {
            if (listener instanceof EventContextManagingAutoFlushEventListener && original instanceof AutoFlushEventListener) {
                ((EventContextManagingAutoFlushEventListener)listener).setDelegate((AutoFlushEventListener)original);
                return true;
            }
            return false;
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.REPLACE_ORIGINAL;
        }
    }
}

