/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.spi.BaseSchemaDefiner;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;

public class SchemaDefinerInitiator
implements SessionFactoryServiceInitiator<SchemaDefiner> {
    public static final SchemaDefinerInitiator INSTANCE = new SchemaDefinerInitiator();
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    public Class<SchemaDefiner> getServiceInitiated() {
        return SchemaDefiner.class;
    }

    public SchemaDefiner initiateService(SessionFactoryImplementor sessionFactory, SessionFactoryOptions sessionFactoryOptions, ServiceRegistryImplementor registry) {
        DatastoreProvider datastoreProvider = (DatastoreProvider)registry.getService(DatastoreProvider.class);
        Class<? extends SchemaDefiner> schemaInitializerType = datastoreProvider.getSchemaDefinerType();
        if (schemaInitializerType != null) {
            try {
                return schemaInitializerType.newInstance();
            }
            catch (Exception e) {
                throw log.unableToInstantiateType(schemaInitializerType, e);
            }
        }
        return new BaseSchemaDefiner();
    }
}

